/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.template2d.ui.diagram.dialogs;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.template2d.ontology.Template2dResource;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.ui.dialogs.ShowError;

public class BindToIOTableDialog
extends Dialog {
    private Map<String, Resource> entries = new HashMap<String, Resource>();
    private Session session = null;
    private Combo combo = null;
    private Resource flag = null;
    private String currentAlignment = null;
    private int currentIndex = -1;
    private Text indexTxT = null;

    public BindToIOTableDialog(Shell parentShell) {
        super(parentShell);
    }

    public boolean init(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        this.flag = ResourceAdaptionUtils.toSingleResource((Object)selection);
        if (this.flag == null) {
            return false;
        }
        this.session = SimanticsUI.getSession();
        if (this.session == null) {
            return false;
        }
        try {
            this.session.syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph g) throws DatabaseException {
                    BindToIOTableDialog.this.entries.put("", null);
                    DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
                    Layer0 L0 = Layer0.getInstance((ReadGraph)g);
                    Template2dResource TEMPLATE2D = Template2dResource.getInstance((ReadGraph)g);
                    Resource parent = OrderedSetUtils.getSingleOwnerList((ReadGraph)g, (Resource)BindToIOTableDialog.this.flag, (Resource)DiagramResource.getInstance((ReadGraph)g).Composite);
                    Resource diagram = null;
                    Resource template = null;
                    if (parent != null && g.isInstanceOf(parent, DIA.Diagram)) {
                        diagram = parent;
                        template = g.getPossibleObject(diagram, TEMPLATE2D.HasDrawingTemplate);
                    }
                    if (template == null) {
                        return;
                    }
                    Collection children = g.getObjects(template, L0.ConsistsOf);
                    for (Resource child : children) {
                        String name;
                        if (!g.isInstanceOf(child, TEMPLATE2D.FlagTable) || (name = (String)g.getPossibleRelatedValue2(child, L0.HasName, (Binding)Bindings.STRING)) == null) continue;
                        BindToIOTableDialog.this.entries.put(name, child);
                    }
                    BindToIOTableDialog.this.currentAlignment = (String)g.getPossibleRelatedValue(BindToIOTableDialog.this.flag, DIA.Flag_HasIOTableBinding, (Binding)Bindings.STRING);
                    BindToIOTableDialog.this.currentIndex = (Integer)g.getPossibleRelatedValue(BindToIOTableDialog.this.flag, DIA.Flag_HasIOTableRowIndex, (Binding)Bindings.INTEGER);
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        GridLayoutFactory.fillDefaults().margins(8, 8).numColumns(2).applyTo(c);
        GridDataFactory gd1 = GridDataFactory.fillDefaults().span(1, 1);
        Label label = new Label(c, 0);
        label.setText("IO table:");
        gd1.applyTo((Control)label);
        this.combo = new Combo(c, 0);
        int i = 0;
        int selectedIndex = -1;
        for (Map.Entry<String, Resource> entry : this.entries.entrySet()) {
            this.combo.add(entry.getKey());
            if (this.currentAlignment != null && entry.getKey().equals(this.currentAlignment)) {
                selectedIndex = i;
            }
            ++i;
        }
        if (selectedIndex != -1) {
            this.combo.select(selectedIndex);
        } else {
            this.combo.clearSelection();
        }
        gd1.applyTo((Control)this.combo);
        label = new Label(c, 0);
        label.setText("Row index:");
        gd1.applyTo((Control)label);
        this.indexTxT = new Text(c, 2048);
        this.indexTxT.setText("" + this.currentIndex);
        gd1.applyTo((Control)this.indexTxT);
        return c;
    }

    protected void okPressed() {
        try {
            this.currentIndex = -1;
            try {
                this.currentIndex = Integer.parseInt(this.indexTxT.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            final Integer index = this.currentIndex;
            int selectedAlignmentIndex = this.combo.getSelectionIndex();
            String selectedAligmentTxt = null;
            if (selectedAlignmentIndex != -1) {
                selectedAligmentTxt = this.combo.getItem(selectedAlignmentIndex);
            }
            if (selectedAligmentTxt != null) {
                this.currentAlignment = selectedAligmentTxt;
            }
            if (this.currentAlignment != null) {
                if (this.currentAlignment.length() > 0) {
                    this.session.syncRequest((Write)new WriteRequest(){

                        public void perform(WriteGraph g) throws DatabaseException {
                            DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
                            Layer0 L0 = Layer0.getInstance((ReadGraph)g);
                            Template2dResource TEMPLATE2D = Template2dResource.getInstance((ReadGraph)g);
                            g.claimLiteral(BindToIOTableDialog.this.flag, DIA.Flag_HasIOTableBinding, (Object)BindToIOTableDialog.this.currentAlignment, (Binding)Bindings.STRING);
                            g.claimLiteral(BindToIOTableDialog.this.flag, DIA.Flag_HasIOTableRowIndex, (Object)index, (Binding)Bindings.INTEGER);
                        }
                    });
                } else {
                    this.session.syncRequest((Write)new WriteRequest(){

                        public void perform(WriteGraph g) throws DatabaseException {
                            DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
                            Layer0 L0 = Layer0.getInstance((ReadGraph)g);
                            Template2dResource TEMPLATE2D = Template2dResource.getInstance((ReadGraph)g);
                            g.claimLiteral(BindToIOTableDialog.this.flag, DIA.Flag_HasIOTableBinding, (Object)"", (Binding)Bindings.STRING);
                            g.claimLiteral(BindToIOTableDialog.this.flag, DIA.Flag_HasIOTableRowIndex, (Object)-1, (Binding)Bindings.INTEGER);
                        }
                    });
                }
            }
        }
        catch (DatabaseException e) {
            ShowError.showError((String)"Error", (String)"Unexpected database error.", (Throwable)e);
            return;
        }
        catch (NumberFormatException e) {
            ShowError.showError((String)"Error", (String)"Index has to be a number.", (Throwable)e);
            return;
        }
        super.okPressed();
    }

    protected int getShellStyle() {
        return 2160;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Select IO Table Location");
    }
}

