/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.template2d.ui.diagram.adapter;

import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.diagram.profile.StyleBase;
import org.simantics.modeling.template2d.ontology.Template2dResource;
import org.simantics.modeling.template2d.ui.function.All;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.nodes.SingleElementNode;
import org.simantics.scenegraph.loader.ScenegraphLoaderProcess;
import org.simantics.scenegraph.profile.DataNodeMap;
import org.simantics.scenegraph.profile.EvaluationContext;
import org.simantics.scenegraph.profile.Observer;
import org.simantics.scenegraph.profile.common.ProfileVariables;

public class DrawingTemplateStyle
extends StyleBase<INode> {
    private static final String PAGE_TEMPLATE_NODE_NAME = "pageTemplate";

    private static Resource getTemplateScenegraph(ReadGraph graph, Resource runtimeDiagram) throws DatabaseException {
        Template2dResource TEMPLATE2D = Template2dResource.getInstance((ReadGraph)graph);
        Resource template = All.getTemplate(graph, runtimeDiagram);
        if (template == null) {
            return null;
        }
        return graph.getPossibleObject(template, TEMPLATE2D.HasScenegraph);
    }

    public INode calculateStyle(ReadGraph graph, Resource runtimeDiagram, Resource entry, Resource groupItem, Variable activeComposite) throws DatabaseException {
        Resource sceneGraph = DrawingTemplateStyle.getTemplateScenegraph(graph, runtimeDiagram);
        if (sceneGraph == null) {
            return null;
        }
        ScenegraphLoaderProcess loader = new ScenegraphLoaderProcess((INode)new G2DParentNode(), "TemplateStyle.calculate");
        return loader.load((RequestProcessor)graph, sceneGraph, runtimeDiagram);
    }

    public void applyStyleForItem(EvaluationContext evaluationContext, DataNodeMap map, Object item, INode node) {
        if (node == null) {
            return;
        }
        G2DSceneGraph sg = evaluationContext.getSceneGraph();
        if (sg == null) {
            return;
        }
        G2DParentNode nav = (G2DParentNode)sg.getNode("navigation");
        if (nav == null) {
            return;
        }
        SingleElementNode pageTemplate = (SingleElementNode)ProfileVariables.claimChild((INode)evaluationContext.getSceneGraph(), (String)"navigation", (String)PAGE_TEMPLATE_NODE_NAME, SingleElementNode.class, (Observer)evaluationContext);
        if (pageTemplate == null) {
            return;
        }
        pageTemplate.setZIndex(1);
        pageTemplate.setVisible(Boolean.valueOf(true));
        pageTemplate.getOrAttachNode("structure", node);
    }

    protected void cleanupStyleForItem(EvaluationContext evaluationContext, DataNodeMap map, Object item) {
        G2DSceneGraph sg = evaluationContext.getSceneGraph();
        if (sg == null) {
            return;
        }
        G2DParentNode nav = (G2DParentNode)sg.getNode("navigation");
        if (nav == null) {
            return;
        }
        G2DParentNode pageTemplate = (G2DParentNode)nav.getNode(PAGE_TEMPLATE_NODE_NAME);
        if (pageTemplate == null) {
            return;
        }
        pageTemplate.detachNode("structure");
        ProfileVariables.denyChild((INode)evaluationContext.getSceneGraph(), (String)"navigation", (String)PAGE_TEMPLATE_NODE_NAME);
    }

    public String toString() {
        return "Template";
    }
}

