/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.template2d.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.request.Write;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.template2d.ontology.Template2dResource;
import org.simantics.scenegraph.ontology.ScenegraphResources;
import org.simantics.ui.SimanticsUI;

public class NewScenegraph
implements ActionFactory {
    public Runnable create(Object target) {
        if (!(target instanceof Resource)) {
            return null;
        }
        final Resource parent = (Resource)target;
        return new Runnable(){

            @Override
            public void run() {
                SimanticsUI.getSession().asyncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph g) throws DatabaseException {
                        NewScenegraph.createVisualComposite(g, parent);
                    }
                });
            }
        };
    }

    public static Resource createVisualComposite(WriteGraph g, Resource parent) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        Template2dResource TEMPLATE2D = Template2dResource.getInstance((ReadGraph)g);
        ScenegraphResources SG = ScenegraphResources.getInstance((ReadGraph)g);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
        G2DResource G2D = G2DResource.getInstance((ReadGraph)g);
        Resource composite = g.newResource();
        g.claim(composite, L0.InstanceOf, null, DIA.Scenegraph_Composite);
        g.claim(composite, L0.InstanceOf, null, TEMPLATE2D.CompositeUI);
        String name = NameUtils.findFreshName((ReadGraph)g, (String)"VisualComposite", (Resource)parent, (Resource)L0.ConsistsOf);
        g.addLiteral(composite, L0.HasName, L0.NameOf, L0.String, (Object)name, (Binding)Bindings.STRING);
        g.addLiteral(composite, DIA.Scenegraph_Composite_transform, DIA.Scenegraph_Composite_transform_Inverse, G2D.Transform, (Object)new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0}, Bindings.getBindingUnchecked(double[].class));
        g.claim(composite, SG.Node_children, ListUtils.create((WriteGraph)g, new ArrayList()));
        g.claim(composite, L0.PartOf, parent);
        if (g.isInstanceOf(parent, TEMPLATE2D.DrawingTemplate)) {
            g.claim(parent, TEMPLATE2D.HasScenegraph, composite);
        } else {
            Resource list = g.getPossibleObject(parent, SG.Node_children);
            if (list != null) {
                ListUtils.insertBack((WriteGraph)g, (Resource)list, Arrays.asList(composite));
            }
        }
        CommentMetadata cm = (CommentMetadata)g.getMetadata(CommentMetadata.class);
        g.addMetadata((Metadata)cm.add("Create New Visual Composite."));
        return composite;
    }
}

