/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.template2d.ui.actions;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.request.Write;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.template2d.ontology.Template2dResource;
import org.simantics.ui.SimanticsUI;

public class NewDrawingTemplate
implements ActionFactory {
    public Runnable create(Object target) {
        if (!(target instanceof Resource)) {
            return null;
        }
        final Resource parent = (Resource)target;
        return new Runnable(){

            @Override
            public void run() {
                SimanticsUI.getSession().asyncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph g) throws DatabaseException {
                        NewDrawingTemplate.createDrawingTemplate(g, parent);
                    }
                });
            }
        };
    }

    public static Resource createDrawingTemplate(WriteGraph g, Resource parent) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        Template2dResource TEMPLATE2D = Template2dResource.getInstance((ReadGraph)g);
        G2DResource G2D = G2DResource.getInstance((ReadGraph)g);
        Resource template = g.newResource();
        String name = NameUtils.findFreshName((ReadGraph)g, (String)"Template", (Resource)parent, (Resource)L0.ConsistsOf);
        g.claim(template, L0.InstanceOf, null, TEMPLATE2D.DrawingTemplate);
        g.claim(template, L0.InstanceOf, null, TEMPLATE2D.DrawingTemplateUI);
        g.addLiteral(template, L0.HasName, L0.NameOf, L0.String, (Object)name, (Binding)Bindings.STRING);
        g.addLiteral(template, L0.HasLabel, L0.HasLabel_Inverse, L0.String, (Object)name, (Binding)Bindings.STRING);
        g.claim(template, L0.PartOf, parent);
        Resource page = g.newResource();
        name = NameUtils.findFreshName((ReadGraph)g, (String)"Page", (Resource)template, (Resource)L0.ConsistsOf);
        g.claim(page, L0.InstanceOf, null, TEMPLATE2D.Page);
        g.claim(page, L0.InstanceOf, null, TEMPLATE2D.BrowseNode);
        g.addLiteral(page, L0.HasName, L0.NameOf, L0.String, (Object)name, (Binding)Bindings.STRING);
        g.addLiteral(page, L0.HasLabel, L0.HasLabel_Inverse, L0.String, (Object)name, (Binding)Bindings.STRING);
        g.claim(page, L0.PartOf, template);
        g.claim(template, TEMPLATE2D.HasPage, page);
        g.claimLiteral(template, TEMPLATE2D.HasMargin, (Object)new float[]{10.0f, 10.0f, 10.0f, 10.0f}, (Binding)Bindings.FLOAT_ARRAY);
        g.claim(template, TEMPLATE2D.HasPageOrientation, TEMPLATE2D.PageOrientation_Landscape);
        CommentMetadata cm = (CommentMetadata)g.getMetadata(CommentMetadata.class);
        g.addMetadata((Metadata)cm.add("Create New Diagram Template."));
        return template;
    }

    public static Resource getDrawingTemplateLibrary(ReadGraph graph, Resource model) throws DatabaseException {
        Template2dResource TEMPLATE2D = Template2dResource.getInstance((ReadGraph)graph);
        Resource library = graph.getSingleObject(model, TEMPLATE2D.HasDrawingTemplateRoot);
        return library;
    }
}

