/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.template2d.ui.actions;

import java.util.HashMap;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.Write;
import org.simantics.db.request.WriteInterface;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.template2d.ontology.Template2dResource;
import org.simantics.modeling.template2d.ui.Activator;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.ui.workbench.dialogs.ResourceSelectionDialog2;
import org.simantics.utils.datastructures.Pair;

public class AssignDrawingTemplate
implements ActionFactory {
    public Runnable create(Object target) {
        if (!(target instanceof Resource)) {
            return null;
        }
        final Resource parent = (Resource)target;
        return new Runnable(){

            @Override
            public void run() {
                Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                        Template2dResource TEMPLATE2D = Template2dResource.getInstance((ReadGraph)graph);
                        StructuralResource2 SR = StructuralResource2.getInstance((ReadGraph)graph);
                        if (!graph.isInstanceOf(parent, SR.Composite)) {
                            return;
                        }
                        Resource model = (Resource)graph.sync((ReadInterface)new PossibleModel(parent));
                        if (model == null) {
                            return;
                        }
                        Instances query = (Instances)graph.adapt(TEMPLATE2D.DrawingTemplate, Instances.class);
                        final HashMap<Resource, Pair> map = new HashMap<Resource, Pair>();
                        for (Resource template : query.find((ReadGraph)graph, model)) {
                            String name = (String)graph.getRelatedValue(template, L0.HasName, (Binding)Bindings.STRING);
                            map.put(template, new Pair((Object)name, null));
                        }
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                Object[] result;
                                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                                ResourceSelectionDialog2<Resource> dialog = new ResourceSelectionDialog2<Resource>(shell, map, "Select template from list"){

                                    protected IDialogSettings getBaseDialogSettings() {
                                        return Activator.getDefault().getDialogSettings();
                                    }
                                };
                                if (dialog.open() == 0 && (result = dialog.getResult()) != null && result.length == 1) {
                                    final Resource template = (Resource)result[0];
                                    Simantics.getSession().async((WriteInterface)new WriteRequest(){

                                        public void perform(WriteGraph graph) throws DatabaseException {
                                            AssignDrawingTemplate.assignTemplateToDiagram(graph, parent, template);
                                        }
                                    });
                                }
                            }
                        });
                    }
                });
            }
        };
    }

    public static void assignTemplateToDiagram(WriteGraph graph, Resource parent, Resource template) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Resource diagram = graph.getPossibleObject(parent, MOD.CompositeToDiagram);
        Template2dResource TEMPLATE2D = Template2dResource.getInstance((ReadGraph)graph);
        graph.deny(diagram, TEMPLATE2D.HasDrawingTemplate);
        graph.claim(diagram, TEMPLATE2D.HasDrawingTemplate, null, template);
        String diagramName = NameUtils.getSafeName((ReadGraph)graph, (Resource)parent);
        String templateName = NameUtils.getSafeName((ReadGraph)graph, (Resource)template);
        CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
        graph.addMetadata((Metadata)cm.add("Assigned diagram template " + templateName + ", resource " + templateName + " to diagram " + diagramName + ", resource " + diagram));
    }
}

