/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.editors;

import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class BrowserInput
implements IEditorInput {
    private URL url;
    private String name;
    private final boolean showControls;
    private final boolean fullscreen;
    private int browserStyle = 0;

    public BrowserInput(URL url) {
        this.url = url;
        this.showControls = true;
        this.fullscreen = false;
    }

    public BrowserInput(URL url, String name) {
        this.url = url;
        this.showControls = true;
        this.fullscreen = false;
    }

    public BrowserInput(URL url, boolean showControls) {
        this.url = url;
        this.showControls = showControls;
        this.fullscreen = false;
    }

    public BrowserInput(URL url, boolean showControls, boolean fullscreen) {
        this.url = url;
        this.showControls = showControls;
        this.fullscreen = fullscreen;
    }

    public BrowserInput(URL url, boolean showControls, boolean fullscreen, int style) {
        this(url, null, showControls, fullscreen, style);
    }

    public BrowserInput(URL url, String name, boolean showControls, boolean fullscreen, int style) {
        this.url = url;
        this.name = name;
        this.showControls = showControls;
        this.fullscreen = fullscreen;
        this.browserStyle = style;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public URL getUrl() {
        return this.url;
    }

    public boolean isShowControls() {
        return this.showControls;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.url.toString();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.getUrl().toString();
    }

    public boolean isFullscreen() {
        return this.fullscreen;
    }

    public int getBrowserStyle() {
        return this.browserStyle;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.browserStyle;
        result = 31 * result + (this.fullscreen ? 1231 : 1237);
        result = 31 * result + (this.showControls ? 1231 : 1237);
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BrowserInput other = (BrowserInput)obj;
        if (this.browserStyle != other.browserStyle) {
            return false;
        }
        if (this.fullscreen != other.fullscreen) {
            return false;
        }
        if (this.showControls != other.showControls) {
            return false;
        }
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }
}

