/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.IOException;
import java.io.InputStream;

class BitStream {
    private final InputStream in;
    private long bitCache;
    private int bitCacheSize;
    private static final int[] MASKS;

    static {
        int[] nArray = new int[9];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 7;
        nArray[4] = 15;
        nArray[5] = 31;
        nArray[6] = 63;
        nArray[7] = 127;
        nArray[8] = 255;
        MASKS = nArray;
    }

    BitStream(InputStream in) {
        this.in = in;
    }

    private boolean fillCache() throws IOException {
        boolean filled = false;
        while (this.bitCacheSize <= 56) {
            long nextByte = this.in.read();
            if (nextByte == -1L) break;
            filled = true;
            this.bitCache |= nextByte << this.bitCacheSize;
            this.bitCacheSize += 8;
        }
        return filled;
    }

    int nextBit() throws IOException {
        if (this.bitCacheSize == 0 && !this.fillCache()) {
            return -1;
        }
        int bit = (int)(this.bitCache & 1L);
        this.bitCache >>>= 1;
        --this.bitCacheSize;
        return bit;
    }

    int nextBits(int n) throws IOException {
        if (this.bitCacheSize < n && !this.fillCache()) {
            return -1;
        }
        int bits = (int)(this.bitCache & (long)MASKS[n]);
        this.bitCache >>>= n;
        this.bitCacheSize -= n;
        return bits;
    }

    int nextByte() throws IOException {
        return this.nextBits(8);
    }
}

