/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.commons.compress.archivers.zip.BitStream;

class BinaryTree {
    private static final int UNDEFINED = -1;
    private static final int NODE = -2;
    private final int[] tree;

    public BinaryTree(int depth) {
        this.tree = new int[(1 << depth + 1) - 1];
        Arrays.fill(this.tree, -1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addLeaf(int node, int path, int depth, int value) {
        if (depth == 0) {
            if (this.tree[node] != -1) throw new IllegalArgumentException("Tree value at index " + node + " has already been assigned (" + this.tree[node] + ")");
            this.tree[node] = value;
            return;
        } else {
            this.tree[node] = -2;
            int nextChild = 2 * node + 1 + (path & 1);
            this.addLeaf(nextChild, path >>> 1, depth - 1, value);
        }
    }

    public int read(BitStream stream) throws IOException {
        int value;
        int bit;
        int currentIndex = 0;
        while (true) {
            if ((bit = stream.nextBit()) == -1) {
                return -1;
            }
            int childIndex = 2 * currentIndex + 1 + bit;
            value = this.tree[childIndex];
            if (value != -2) break;
            currentIndex = childIndex;
        }
        if (value != -1) {
            return value;
        }
        throw new IOException("The child " + bit + " of node at index " + currentIndex + " is not defined");
    }

    static BinaryTree decode(InputStream in, int totalNumberOfValues) throws IOException {
        int size = in.read() + 1;
        if (size == 0) {
            throw new IOException("Cannot read the size of the encoded tree, unexpected end of stream");
        }
        byte[] encodedTree = new byte[size];
        new DataInputStream(in).readFully(encodedTree);
        int maxLength = 0;
        int[] originalBitLengths = new int[totalNumberOfValues];
        int pos = 0;
        byte[] byArray = encodedTree;
        int n = encodedTree.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            int numberOfValues = ((b & 0xF0) >> 4) + 1;
            int bitLength = (b & 0xF) + 1;
            int j = 0;
            while (j < numberOfValues) {
                originalBitLengths[pos++] = bitLength;
                ++j;
            }
            maxLength = Math.max(maxLength, bitLength);
            ++n2;
        }
        int[] permutation = new int[originalBitLengths.length];
        int k = 0;
        while (k < permutation.length) {
            permutation[k] = k;
            ++k;
        }
        int c = 0;
        int[] sortedBitLengths = new int[originalBitLengths.length];
        int k2 = 0;
        while (k2 < originalBitLengths.length) {
            int l = 0;
            while (l < originalBitLengths.length) {
                if (originalBitLengths[l] == k2) {
                    sortedBitLengths[c] = k2;
                    permutation[c] = l;
                    ++c;
                }
                ++l;
            }
            ++k2;
        }
        int code = 0;
        int codeIncrement = 0;
        int lastBitLength = 0;
        int[] codes = new int[totalNumberOfValues];
        int i = totalNumberOfValues - 1;
        while (i >= 0) {
            code += codeIncrement;
            if (sortedBitLengths[i] != lastBitLength) {
                lastBitLength = sortedBitLengths[i];
                codeIncrement = 1 << 16 - lastBitLength;
            }
            codes[permutation[i]] = code;
            --i;
        }
        BinaryTree tree = new BinaryTree(maxLength);
        int k3 = 0;
        while (k3 < codes.length) {
            int bitLength = originalBitLengths[k3];
            if (bitLength > 0) {
                tree.addLeaf(0, Integer.reverse(codes[k3] << 16), bitLength, k3);
            }
            ++k3;
        }
        return tree;
    }
}

