/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.tar;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.commons.compress.archivers.zip.ZipEncoding;
import org.apache.commons.compress.archivers.zip.ZipEncodingHelper;

public class TarUtils {
    private static final int BYTE_MASK = 255;
    static final ZipEncoding DEFAULT_ENCODING = ZipEncodingHelper.getZipEncoding(null);
    static final ZipEncoding FALLBACK_ENCODING = new ZipEncoding(){

        @Override
        public boolean canEncode(String name) {
            return true;
        }

        @Override
        public ByteBuffer encode(String name) {
            int length = name.length();
            byte[] buf = new byte[length];
            int i = 0;
            while (i < length) {
                buf[i] = (byte)name.charAt(i);
                ++i;
            }
            return ByteBuffer.wrap(buf);
        }

        @Override
        public String decode(byte[] buffer) {
            int length = buffer.length;
            StringBuilder result = new StringBuilder(length);
            int i = 0;
            while (i < length) {
                byte b = buffer[i];
                if (b == 0) break;
                result.append((char)(b & 0xFF));
                ++i;
            }
            return result.toString();
        }
    };

    private TarUtils() {
    }

    /*
     * Unable to fully structure code
     */
    public static long parseOctal(byte[] buffer, int offset, int length) {
        result = 0L;
        end = offset + length;
        start = offset;
        if (length < 2) {
            throw new IllegalArgumentException("Length " + length + " must be at least 2");
        }
        if (buffer[start] != 0) ** GOTO lbl10
        return 0L;
        while (buffer[start] == 32) {
            ++start;
lbl10:
            // 2 sources

            if (start < end) continue;
        }
        if ((trailer = buffer[end - 1]) != 0 && trailer != 32) {
            throw new IllegalArgumentException(TarUtils.exceptionMessage(buffer, offset, length, end - 1, trailer));
        }
        trailer = buffer[--end - 1];
        while (start < end - 1 && (trailer == 0 || trailer == 32)) {
            trailer = buffer[--end - 1];
        }
        while (start < end) {
            currentByte = buffer[start];
            if (currentByte < 48 || currentByte > 55) {
                throw new IllegalArgumentException(TarUtils.exceptionMessage(buffer, offset, length, start, currentByte));
            }
            result = (result << 3) + (long)(currentByte - 48);
            ++start;
        }
        return result;
    }

    public static long parseOctalOrBinary(byte[] buffer, int offset, int length) {
        boolean negative;
        if ((buffer[offset] & 0x80) == 0) {
            return TarUtils.parseOctal(buffer, offset, length);
        }
        boolean bl = negative = buffer[offset] == -1;
        if (length < 9) {
            return TarUtils.parseBinaryLong(buffer, offset, length, negative);
        }
        return TarUtils.parseBinaryBigInteger(buffer, offset, length, negative);
    }

    private static long parseBinaryLong(byte[] buffer, int offset, int length, boolean negative) {
        if (length >= 9) {
            throw new IllegalArgumentException("At offset " + offset + ", " + length + " byte binary number" + " exceeds maximum signed long" + " value");
        }
        long val = 0L;
        int i = 1;
        while (i < length) {
            val = (val << 8) + (long)(buffer[offset + i] & 0xFF);
            ++i;
        }
        if (negative) {
            --val;
            val ^= (long)Math.pow(2.0, (length - 1) * 8) - 1L;
        }
        return negative ? -val : val;
    }

    private static long parseBinaryBigInteger(byte[] buffer, int offset, int length, boolean negative) {
        byte[] remainder = new byte[length - 1];
        System.arraycopy(buffer, offset + 1, remainder, 0, length - 1);
        BigInteger val = new BigInteger(remainder);
        if (negative) {
            val = val.add(BigInteger.valueOf(-1L)).not();
        }
        if (val.bitLength() > 63) {
            throw new IllegalArgumentException("At offset " + offset + ", " + length + " byte binary number" + " exceeds maximum signed long" + " value");
        }
        return negative ? -val.longValue() : val.longValue();
    }

    public static boolean parseBoolean(byte[] buffer, int offset) {
        return buffer[offset] == 1;
    }

    private static String exceptionMessage(byte[] buffer, int offset, int length, int current, byte currentByte) {
        String string = new String(buffer, offset, length);
        string = string.replaceAll("\u0000", "{NUL}");
        String s = "Invalid byte " + currentByte + " at offset " + (current - offset) + " in '" + string + "' len=" + length;
        return s;
    }

    public static String parseName(byte[] buffer, int offset, int length) {
        try {
            return TarUtils.parseName(buffer, offset, length, DEFAULT_ENCODING);
        }
        catch (IOException iOException) {
            try {
                return TarUtils.parseName(buffer, offset, length, FALLBACK_ENCODING);
            }
            catch (IOException ex2) {
                throw new RuntimeException(ex2);
            }
        }
    }

    public static String parseName(byte[] buffer, int offset, int length, ZipEncoding encoding) throws IOException {
        int len = length;
        while (len > 0) {
            if (buffer[offset + len - 1] != 0) break;
            --len;
        }
        if (len > 0) {
            byte[] b = new byte[len];
            System.arraycopy(buffer, offset, b, 0, len);
            return encoding.decode(b);
        }
        return "";
    }

    public static int formatNameBytes(String name, byte[] buf, int offset, int length) {
        try {
            return TarUtils.formatNameBytes(name, buf, offset, length, DEFAULT_ENCODING);
        }
        catch (IOException iOException) {
            try {
                return TarUtils.formatNameBytes(name, buf, offset, length, FALLBACK_ENCODING);
            }
            catch (IOException ex2) {
                throw new RuntimeException(ex2);
            }
        }
    }

    public static int formatNameBytes(String name, byte[] buf, int offset, int length, ZipEncoding encoding) throws IOException {
        int len = name.length();
        ByteBuffer b = encoding.encode(name);
        while (b.limit() > length && len > 0) {
            b = encoding.encode(name.substring(0, --len));
        }
        int limit = b.limit() - b.position();
        System.arraycopy(b.array(), b.arrayOffset(), buf, offset, limit);
        int i = limit;
        while (i < length) {
            buf[offset + i] = 0;
            ++i;
        }
        return offset + length;
    }

    /*
     * Unable to fully structure code
     */
    public static void formatUnsignedOctalString(long value, byte[] buffer, int offset, int length) {
        block2: {
            remaining = length;
            --remaining;
            if (value != 0L) break block2;
            buffer[offset + remaining--] = 48;
            ** GOTO lbl17
        }
        val = value;
        while (remaining >= 0 && val != 0L) {
            buffer[offset + remaining] = (byte)(48 + (byte)(val & 7L));
            val >>>= 3;
            --remaining;
        }
        if (val == 0L) ** GOTO lbl17
        throw new IllegalArgumentException(String.valueOf(value) + "=" + Long.toOctalString(value) + " will not fit in octal number buffer of length " + length);
lbl-1000:
        // 1 sources

        {
            buffer[offset + remaining] = 48;
            --remaining;
lbl17:
            // 3 sources

            ** while (remaining >= 0)
        }
lbl18:
        // 1 sources

    }

    public static int formatOctalBytes(long value, byte[] buf, int offset, int length) {
        int idx = length - 2;
        TarUtils.formatUnsignedOctalString(value, buf, offset, idx);
        buf[offset + idx++] = 32;
        buf[offset + idx] = 0;
        return offset + length;
    }

    public static int formatLongOctalBytes(long value, byte[] buf, int offset, int length) {
        int idx = length - 1;
        TarUtils.formatUnsignedOctalString(value, buf, offset, idx);
        buf[offset + idx] = 32;
        return offset + length;
    }

    public static int formatLongOctalOrBinaryBytes(long value, byte[] buf, int offset, int length) {
        boolean negative;
        long maxAsOctalChar = length == 8 ? 0x1FFFFFL : 0x1FFFFFFFFL;
        boolean bl = negative = value < 0L;
        if (!negative && value <= maxAsOctalChar) {
            return TarUtils.formatLongOctalBytes(value, buf, offset, length);
        }
        if (length < 9) {
            TarUtils.formatLongBinary(value, buf, offset, length, negative);
        }
        TarUtils.formatBigIntegerBinary(value, buf, offset, length, negative);
        buf[offset] = (byte)(negative ? 255 : 128);
        return offset + length;
    }

    private static void formatLongBinary(long value, byte[] buf, int offset, int length, boolean negative) {
        int bits = (length - 1) * 8;
        long max = 1L << bits;
        long val = Math.abs(value);
        if (val >= max) {
            throw new IllegalArgumentException("Value " + value + " is too large for " + length + " byte field.");
        }
        if (negative) {
            val ^= max - 1L;
            val |= (long)(255 << bits);
            ++val;
        }
        int i = offset + length - 1;
        while (i >= offset) {
            buf[i] = (byte)val;
            val >>= 8;
            --i;
        }
    }

    private static void formatBigIntegerBinary(long value, byte[] buf, int offset, int length, boolean negative) {
        BigInteger val = BigInteger.valueOf(value);
        byte[] b = val.toByteArray();
        int len = b.length;
        int off = offset + length - len;
        System.arraycopy(b, 0, buf, off, len);
        byte fill = (byte)(negative ? 255 : 0);
        int i = offset + 1;
        while (i < off) {
            buf[i] = fill;
            ++i;
        }
    }

    public static int formatCheckSumOctalBytes(long value, byte[] buf, int offset, int length) {
        int idx = length - 2;
        TarUtils.formatUnsignedOctalString(value, buf, offset, idx);
        buf[offset + idx++] = 0;
        buf[offset + idx] = 32;
        return offset + length;
    }

    public static long computeCheckSum(byte[] buf) {
        long sum = 0L;
        byte[] byArray = buf;
        int n = buf.length;
        int n2 = 0;
        while (n2 < n) {
            byte element = byArray[n2];
            sum += (long)(0xFF & element);
            ++n2;
        }
        return sum;
    }

    public static boolean verifyCheckSum(byte[] header) {
        long storedSum = 0L;
        long unsignedSum = 0L;
        long signedSum = 0L;
        int digits = 0;
        int i = 0;
        while (i < header.length) {
            int b = header[i];
            if (148 <= i && i < 156) {
                if (48 <= b && b <= 55 && digits++ < 6) {
                    storedSum = storedSum * 8L + (long)b - 48L;
                } else if (digits > 0) {
                    digits = 6;
                }
                b = 32;
            }
            unsignedSum += (long)(0xFF & b);
            signedSum += (long)b;
            ++i;
        }
        return storedSum == unsignedSum || storedSum == signedSum || storedSum > unsignedSum;
    }
}

