/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.cpio;

class CpioUtil {
    CpioUtil() {
    }

    static long fileType(long mode) {
        return mode & 0xF000L;
    }

    static long byteArray2long(byte[] number, boolean swapHalfWord) {
        if (number.length % 2 != 0) {
            throw new UnsupportedOperationException();
        }
        long ret = 0L;
        int pos = 0;
        byte[] tmp_number = new byte[number.length];
        System.arraycopy(number, 0, tmp_number, 0, number.length);
        if (!swapHalfWord) {
            byte tmp = 0;
            pos = 0;
            while (pos < tmp_number.length) {
                tmp = tmp_number[pos];
                tmp_number[pos++] = tmp_number[pos];
                tmp_number[pos] = tmp;
                ++pos;
            }
        }
        ret = tmp_number[0] & 0xFF;
        pos = 1;
        while (pos < tmp_number.length) {
            ret <<= 8;
            ret |= (long)(tmp_number[pos] & 0xFF);
            ++pos;
        }
        return ret;
    }

    static byte[] long2byteArray(long number, int length, boolean swapHalfWord) {
        byte[] ret = new byte[length];
        int pos = 0;
        long tmp_number = 0L;
        if (length % 2 != 0 || length < 2) {
            throw new UnsupportedOperationException();
        }
        tmp_number = number;
        pos = length - 1;
        while (pos >= 0) {
            ret[pos] = (byte)(tmp_number & 0xFFL);
            tmp_number >>= 8;
            --pos;
        }
        if (!swapHalfWord) {
            byte tmp = 0;
            pos = 0;
            while (pos < length) {
                tmp = ret[pos];
                ret[pos++] = ret[pos];
                ret[pos] = tmp;
                ++pos;
            }
        }
        return ret;
    }
}

