/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.export.core.manager;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.simantics.Simantics;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.util.URIUtil;
import org.simantics.export.core.ExportContext;
import org.simantics.export.core.error.ExportException;
import org.simantics.export.core.intf.Exporter;
import org.simantics.export.core.intf.Format;
import org.simantics.export.core.manager.Content;
import org.simantics.export.core.manager.ExportAction;
import org.simantics.export.core.util.ExporterUtils;
import org.simantics.utils.datastructures.MapList;
import org.simantics.utils.strings.AlphanumComparator;

public class ExportGroupCreateAction
extends ExportAction {
    public Content dstContent;
    public List<Content> contents = new ArrayList<Content>();
    public MapList<Content, Content> attachments = new MapList();
    public String formatId;
    public File outputFile;
    Comparator<List<Exporter>> EXPORTER_LIST_COMPARATOR = new Comparator<List<Exporter>>(){

        String repr(List<Exporter> l) {
            Iterator<Exporter> iterator = l.iterator();
            if (iterator.hasNext()) {
                Exporter e = iterator.next();
                return e.contentTypeId();
            }
            throw new IllegalArgumentException("empty exporter list");
        }

        @Override
        public int compare(List<Exporter> o1, List<Exporter> o2) {
            String k1 = this.repr(o1);
            String k2 = this.repr(o2);
            return AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)k1, (Object)k2);
        }
    };

    public ExportGroupCreateAction(Content dstContent, String formatId) {
        this.dstContent = dstContent;
        this.formatId = formatId;
    }

    public void addContent(Content srcContent, List<Content> attachments) {
        if (srcContent != null) {
            this.contents.add(srcContent);
        }
        if (attachments != null) {
            this.attachments.addAll((Object)srcContent, attachments);
        }
    }

    @Override
    public void execute(ExportContext ctx, IProgressMonitor monitor, Variant options) throws ExportException {
        Format format = ctx.eep.getFormat(this.formatId);
        MapList map = new MapList();
        for (Content content : this.contents) {
            Object exporters = ctx.eep.getExporters(content.formatId, content.contentTypeId);
            if (((Exporter[])exporters).length == 0) {
                throw new ExportException("No suitable exporter found for exporting " + content.contentTypeId + " to a " + format.label());
            }
            map.add(Arrays.asList(exporters), (Object)content);
        }
        try {
            String prefix = "___" + URIUtil.encodeFilename((String)this.dstContent.label);
            this.dstContent.tmpFile = this.outputFile = File.createTempFile(prefix, URIUtil.encodeFilename((String)format.fileext()), Simantics.getTemporaryDirectory((String)"export.core"));
        }
        catch (IOException e) {
            throw new ExportException(e);
        }
        int totalWork = 0;
        int singleExportWork = 10000;
        for (Object exporters : map.getKeys()) {
            List contents = map.getValues(exporters);
            totalWork += (contents.size() * exporters.size() + 1) * 10000;
        }
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)totalWork);
        Object writer = format.createFile(ctx, this.outputFile, options);
        try {
            try {
                ArrayList sortedKeys = new ArrayList(map.getKeys());
                Collections.sort(sortedKeys, this.EXPORTER_LIST_COMPARATOR);
                for (List exporters : sortedKeys) {
                    List contents = map.getValues((Object)exporters);
                    List<Content> sortedContent = ExporterUtils.sortedContent(contents);
                    for (Content content : sortedContent) {
                        for (Exporter exporter : exporters) {
                            if (monitor.isCanceled()) {
                                throw new OperationCanceledException();
                            }
                            mon.subTask(String.valueOf(exporter.formatId()) + ": " + content.label);
                            exporter.exportAction().export(Collections.singletonList(content), writer, ctx, options, (IProgressMonitor)mon.newChild(10000), this.attachments);
                        }
                    }
                }
                List remainingAttachments = this.attachments.getValues(null);
                if (remainingAttachments != null && !remainingAttachments.isEmpty()) {
                    format.addAttachment(ctx, writer, remainingAttachments);
                }
                this.dstContent.tmpFile = this.outputFile;
            }
            catch (ExportException ee) {
                if (this.outputFile.exists()) {
                    this.outputFile.delete();
                }
                throw ee;
            }
        }
        finally {
            if (writer != null) {
                format.closeFile(ctx, writer);
                mon.worked(10000);
                writer = null;
            }
        }
    }

    @Override
    public String label(ExportContext ctx) {
        Format format = ctx.eep.getFormat(this.formatId);
        String label = this.contents.size() == 1 ? this.contents.iterator().next().label : "Writing " + this.contents.size() + " items to a " + format.label() + " file";
        if (this.outputFile == null) {
            return label;
        }
        return String.valueOf(label) + " export to " + this.outputFile.getName();
    }

    @Override
    public int work(ExportContext ctx) {
        return this.contents.size() + 1;
    }

    @Override
    public List<String> validate(ExportContext ctx, Variant options) {
        ArrayList<String> result = new ArrayList<String>(0);
        for (Content content : this.contents) {
            Exporter[] exporters = ctx.eep.getExporters(this.formatId, content.contentTypeId);
            if (exporters.length == 0) {
                result.add("Could not find exporter for " + content.filename);
                continue;
            }
            Exporter[] exporterArray = exporters;
            int n = exporters.length;
            int n2 = 0;
            while (n2 < n) {
                Exporter exporter = exporterArray[n2];
                try {
                    result.addAll(exporter.exportAction().validate(content.url, ctx, options));
                }
                catch (ExportException e) {
                    result.add(String.valueOf(e.getClass().getName()) + ": " + e.getMessage());
                }
                ++n2;
            }
        }
        return result;
    }

    @Override
    public void cleanup(ExportContext ctx, IProgressMonitor progress, Variant options) throws ExportException {
        if (this.outputFile != null) {
            this.outputFile.delete();
            this.dstContent.tmpFile = null;
        }
    }

    public List<Content> getAttachments() {
        ArrayList<Content> result = new ArrayList<Content>();
        for (Content key : this.attachments.getKeys()) {
            for (Content value : this.attachments.getValues((Object)key)) {
                if (result.contains(value)) continue;
                result.add(value);
            }
        }
        return result;
    }
}

