/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.export.core.impl;

import java.io.File;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.service.prefs.Preferences;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.type.RecordType;
import org.simantics.export.core.ExportContext;
import org.simantics.export.core.ExportExtensionPoint;
import org.simantics.export.core.error.ExportException;
import org.simantics.export.core.impl.DefaultContentTypeAction;
import org.simantics.export.core.intf.ContentType;
import org.simantics.export.core.intf.ContentTypeAction;
import org.simantics.export.core.intf.DiscoverAction;
import org.simantics.export.core.intf.Discoverer;
import org.simantics.export.core.intf.ExportClass;
import org.simantics.export.core.intf.Exporter;
import org.simantics.export.core.intf.Format;
import org.simantics.export.core.intf.FormatClass;
import org.simantics.export.core.intf.IconResolver;
import org.simantics.export.core.intf.ImportAction;
import org.simantics.export.core.intf.Importer;
import org.simantics.export.core.intf.Publisher;
import org.simantics.export.core.intf.PublisherClass;
import org.simantics.export.core.manager.Content;
import org.simantics.utils.datastructures.ToStringComparator;

public class ExportExtensionPointImpl
implements ExportExtensionPoint {
    public static final String EP = "org.simantics.export.core.export";
    Importer[] importers = this.createImporters();
    Exporter[] exporters = this.createExporters();
    Format[] formats = this.createFormats();
    ContentType[] contentTypes = this.createContentTypes();
    Discoverer[] discoverers = this.createDiscoverers();
    Publisher[] publishers = this.createPublishers();
    Comparator<Exporter> exporterPrioritySorter = new Comparator<Exporter>(){

        @Override
        public int compare(Exporter o1, Exporter o2) {
            return Integer.signum(o2.getExportPriority() - o1.getExportPriority());
        }
    };

    @Override
    public Discoverer[] getDiscoverers(String contentTypeId) {
        int count = 0;
        Discoverer[] discovererArray = this.discoverers;
        int n = this.discoverers.length;
        int n2 = 0;
        while (n2 < n) {
            Discoverer discoverer = discovererArray[n2];
            if (contentTypeId.equals(discoverer.contentTypeId())) {
                ++count;
            }
            ++n2;
        }
        Discoverer[] result = new Discoverer[count];
        int i = 0;
        Discoverer[] discovererArray2 = this.discoverers;
        int n3 = this.discoverers.length;
        int n4 = 0;
        while (n4 < n3) {
            Discoverer discoverer = discovererArray2[n4];
            if (contentTypeId.equals(discoverer.contentTypeId())) {
                result[i++] = discoverer;
            }
            ++n4;
        }
        return result;
    }

    @Override
    public Format getFormat(String formatId) {
        Format[] formatArray = this.formats;
        int n = this.formats.length;
        int n2 = 0;
        while (n2 < n) {
            Format format = formatArray[n2];
            if (formatId.equals(format.id())) {
                return format;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public Format getFormatByExt(String fileExt) {
        Format[] formatArray = this.formats;
        int n = this.formats.length;
        int n2 = 0;
        while (n2 < n) {
            Format format = formatArray[n2];
            if (fileExt.equals(format.fileext())) {
                return format;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public ContentType getContentType(String contentTypeId) {
        ContentType[] contentTypeArray = this.contentTypes;
        int n = this.contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ContentType contentType = contentTypeArray[n2];
            if (contentTypeId.equals(contentType.id())) {
                return contentType;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public Importer getImporter(String formatId) {
        Importer[] importerArray = this.importers;
        int n = this.importers.length;
        int n2 = 0;
        while (n2 < n) {
            Importer importer = importerArray[n2];
            if (formatId.equals(importer.formatId())) {
                return importer;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public Exporter[] getExporters(String formatId, String contentTypeId) {
        int count = 0;
        Exporter[] exporterArray = this.exporters;
        int n = this.exporters.length;
        int n2 = 0;
        while (n2 < n) {
            Exporter exporter = exporterArray[n2];
            if (exporter.formatId().equals(formatId) && exporter.contentTypeId().equals(contentTypeId)) {
                ++count;
            }
            ++n2;
        }
        Exporter[] result = new Exporter[count];
        int index = 0;
        Exporter[] exporterArray2 = this.exporters;
        int n3 = this.exporters.length;
        int n4 = 0;
        while (n4 < n3) {
            Exporter exporter = exporterArray2[n4];
            if (formatId.equals(exporter.formatId()) && contentTypeId.equals(exporter.contentTypeId())) {
                result[index++] = exporter;
            }
            ++n4;
        }
        return result;
    }

    @Override
    public Exporter[] getExportersForContentType(String contentTypeId) {
        int count = 0;
        Exporter[] exporterArray = this.exporters;
        int n = this.exporters.length;
        int n2 = 0;
        while (n2 < n) {
            Exporter exporter = exporterArray[n2];
            if (contentTypeId.equals(exporter.contentTypeId())) {
                ++count;
            }
            ++n2;
        }
        Exporter[] result = new Exporter[count];
        int i = 0;
        Exporter[] exporterArray2 = this.exporters;
        int n3 = this.exporters.length;
        int n4 = 0;
        while (n4 < n3) {
            Exporter exporter = exporterArray2[n4];
            if (contentTypeId.equals(exporter.contentTypeId())) {
                result[i++] = exporter;
            }
            ++n4;
        }
        Arrays.sort(result, this.exporterPrioritySorter);
        return result;
    }

    @Override
    public Exporter[] getExportersForFormat(String formatId) {
        int count = 0;
        Exporter[] exporterArray = this.exporters;
        int n = this.exporters.length;
        int n2 = 0;
        while (n2 < n) {
            Exporter exporter = exporterArray[n2];
            if (formatId.equals(exporter.formatId())) {
                ++count;
            }
            ++n2;
        }
        Exporter[] result = new Exporter[count];
        int i = 0;
        Exporter[] exporterArray2 = this.exporters;
        int n3 = this.exporters.length;
        int n4 = 0;
        while (n4 < n3) {
            Exporter exporter = exporterArray2[n4];
            if (formatId.equals(exporter.formatId())) {
                result[i++] = exporter;
            }
            ++n4;
        }
        Arrays.sort(result, this.exporterPrioritySorter);
        return result;
    }

    @Override
    public Publisher getPublisher(String publisherId) {
        Publisher[] publisherArray = this.publishers;
        int n = this.publishers.length;
        int n2 = 0;
        while (n2 < n) {
            Publisher publisher = publisherArray[n2];
            if (publisherId.equals(publisher.id())) {
                return publisher;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public int getPublisherIndex(String publisherId) {
        int i = 0;
        while (i < this.publishers.length) {
            if (publisherId.equals(this.publishers[i].id())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public Publisher getPublisherByLabel(String publisherLabel) {
        Publisher[] publisherArray = this.publishers;
        int n = this.publishers.length;
        int n2 = 0;
        while (n2 < n) {
            Publisher publisher = publisherArray[n2];
            if (publisher.label().equals(publisherLabel)) {
                return publisher;
            }
            ++n2;
        }
        return null;
    }

    ContentType[] createContentTypes() {
        IConfigurationElement[] ces = Platform.getExtensionRegistry().getConfigurationElementsFor(EP);
        int count = 0;
        IConfigurationElement[] iConfigurationElementArray = ces;
        int n = ces.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            if ("content_type".equals(ce.getName())) {
                ++count;
            }
            ++n2;
        }
        ContentType[] result = new ContentType[count];
        int i = 0;
        IConfigurationElement[] iConfigurationElementArray2 = ces;
        int n3 = ces.length;
        int n4 = 0;
        while (n4 < n3) {
            IConfigurationElement ce = iConfigurationElementArray2[n4];
            if ("content_type".equals(ce.getName())) {
                result[i++] = new ContentTypeImpl(ce);
            }
            ++n4;
        }
        return result;
    }

    Discoverer[] createDiscoverers() {
        IConfigurationElement[] ces = Platform.getExtensionRegistry().getConfigurationElementsFor(EP);
        int count = 0;
        IConfigurationElement[] iConfigurationElementArray = ces;
        int n = ces.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            if ("discoverer".equals(ce.getName())) {
                ++count;
            }
            ++n2;
        }
        Discoverer[] result = new Discoverer[count];
        int i = 0;
        IConfigurationElement[] iConfigurationElementArray2 = ces;
        int n3 = ces.length;
        int n4 = 0;
        while (n4 < n3) {
            IConfigurationElement ce = iConfigurationElementArray2[n4];
            if ("discoverer".equals(ce.getName())) {
                result[i++] = new DiscovererImpl(ce);
            }
            ++n4;
        }
        return result;
    }

    Format[] createFormats() {
        IConfigurationElement[] ces = Platform.getExtensionRegistry().getConfigurationElementsFor(EP);
        int count = 0;
        IConfigurationElement[] iConfigurationElementArray = ces;
        int n = ces.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            if ("format".equals(ce.getName())) {
                ++count;
            }
            ++n2;
        }
        Format[] result = new Format[count];
        int i = 0;
        IConfigurationElement[] iConfigurationElementArray2 = ces;
        int n3 = ces.length;
        int n4 = 0;
        while (n4 < n3) {
            IConfigurationElement ce = iConfigurationElementArray2[n4];
            if ("format".equals(ce.getName())) {
                result[i++] = new FormatImpl(ce);
            }
            ++n4;
        }
        return result;
    }

    Exporter[] createExporters() {
        IConfigurationElement[] ces = Platform.getExtensionRegistry().getConfigurationElementsFor(EP);
        int count = 0;
        IConfigurationElement[] iConfigurationElementArray = ces;
        int n = ces.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            if ("exporter".equals(ce.getName())) {
                ++count;
            }
            ++n2;
        }
        Exporter[] result = new Exporter[count];
        int i = 0;
        IConfigurationElement[] iConfigurationElementArray2 = ces;
        int n3 = ces.length;
        int n4 = 0;
        while (n4 < n3) {
            IConfigurationElement ce = iConfigurationElementArray2[n4];
            if ("exporter".equals(ce.getName())) {
                result[i++] = new ExporterImpl(ce);
            }
            ++n4;
        }
        return result;
    }

    Importer[] createImporters() {
        IConfigurationElement[] ces = Platform.getExtensionRegistry().getConfigurationElementsFor(EP);
        int count = 0;
        IConfigurationElement[] iConfigurationElementArray = ces;
        int n = ces.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            if ("importer".equals(ce.getName())) {
                ++count;
            }
            ++n2;
        }
        Importer[] result = new Importer[count];
        int i = 0;
        IConfigurationElement[] iConfigurationElementArray2 = ces;
        int n3 = ces.length;
        int n4 = 0;
        while (n4 < n3) {
            IConfigurationElement ce = iConfigurationElementArray2[n4];
            if ("importer".equals(ce.getName())) {
                result[i++] = new ImporterImpl(ce);
            }
            ++n4;
        }
        return result;
    }

    Publisher[] createPublishers() {
        IConfigurationElement[] ces = Platform.getExtensionRegistry().getConfigurationElementsFor(EP);
        int count = 0;
        IConfigurationElement[] iConfigurationElementArray = ces;
        int n = ces.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            if ("publisher".equals(ce.getName())) {
                ++count;
            }
            ++n2;
        }
        Publisher[] result = new Publisher[count];
        int i = 0;
        IConfigurationElement[] iConfigurationElementArray2 = ces;
        int n3 = ces.length;
        int n4 = 0;
        while (n4 < n3) {
            IConfigurationElement ce = iConfigurationElementArray2[n4];
            if ("publisher".equals(ce.getName())) {
                result[i++] = new PublisherImpl(ce);
            }
            ++n4;
        }
        Arrays.sort(result, new ToStringComparator.ByLength());
        return result;
    }

    @Override
    public ContentType[] contentTypes() {
        return this.contentTypes;
    }

    @Override
    public Discoverer[] discoverers() {
        return this.discoverers;
    }

    @Override
    public Format[] formats() {
        return this.formats;
    }

    @Override
    public Importer[] importers() {
        return this.importers;
    }

    @Override
    public Exporter[] exporters() {
        return this.exporters;
    }

    @Override
    public Publisher[] publishers() {
        return this.publishers;
    }

    static class ContentTypeImpl
    implements ContentType {
        IConfigurationElement ce;
        ContentTypeAction action;
        WeakReference<IconResolver> resolverCache = null;
        boolean invalidIconResolver = false;

        public ContentTypeImpl(IConfigurationElement ce) {
            this.ce = ce;
        }

        ContentTypeAction getOrCreate() throws ExportException {
            if (this.action == null) {
                try {
                    String value = this.ce.getAttribute("contentTypeAction");
                    if (value == null) {
                        return new DefaultContentTypeAction();
                    }
                    this.action = (ContentTypeAction)this.ce.createExecutableExtension("contentTypeAction");
                }
                catch (CoreException e) {
                    throw new ExportException(e);
                }
            }
            return this.action;
        }

        @Override
        public String id() {
            return this.ce.getAttribute("id");
        }

        @Override
        public String label() {
            return this.ce.getAttribute("label");
        }

        @Override
        public String plural() {
            return this.ce.getAttribute("plural");
        }

        @Override
        public ImageDescriptor icon(String contentUri) {
            if (!this.invalidIconResolver && this.ce.getAttribute("iconResolver") != null) {
                try {
                    IconResolver resolver;
                    IconResolver iconResolver = resolver = this.resolverCache != null ? (IconResolver)this.resolverCache.get() : null;
                    if (resolver == null) {
                        resolver = (IconResolver)this.ce.createExecutableExtension("iconResolver");
                        this.resolverCache = new WeakReference<IconResolver>(resolver);
                    }
                    return resolver.get(contentUri);
                }
                catch (CoreException e) {
                    this.invalidIconResolver = true;
                    return null;
                }
            }
            return this.icon();
        }

        @Override
        public ImageDescriptor icon() {
            try {
                String _url = this.ce.getAttribute("icon");
                URL url = new URL(_url);
                return ImageDescriptor.createFromURL((URL)url);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }

        @Override
        public boolean isModel() {
            return "true".equalsIgnoreCase(this.ce.getAttribute("model"));
        }

        public String toString() {
            return "ContentType, id=" + this.id() + ", label=" + this.label();
        }

        @Override
        public Map<String, String> getLabels(ExportContext ctx, Collection<String> contents) throws ExportException {
            ContentTypeAction action = this.getOrCreate();
            return action.getLabels(ctx, contents);
        }
    }

    static class DiscovererImpl
    implements Discoverer {
        IConfigurationElement ce;
        DiscoverAction action;

        public DiscovererImpl(IConfigurationElement ce) {
            this.ce = ce;
        }

        @Override
        public String contentTypeId() {
            return this.ce.getAttribute("content_type_id");
        }

        DiscoverAction getOrCreate() throws ExportException {
            if (this.action == null) {
                try {
                    this.action = (DiscoverAction)this.ce.createExecutableExtension("discoverAction");
                }
                catch (CoreException e) {
                    throw new ExportException(e);
                }
            }
            return this.action;
        }

        public String toString() {
            try {
                return "Discoverer, contentTypeId=" + this.contentTypeId() + ", class=" + this.getOrCreate().getClass().getCanonicalName();
            }
            catch (ExportException e) {
                return "Discoverer, contentTypeId=" + this.contentTypeId();
            }
        }

        @Override
        public Collection<String> discoverContent(ExportContext ctx, Collection<String> startLocations) throws ExportException {
            return this.getOrCreate().discoverContent(ctx, startLocations);
        }
    }

    static class ExporterImpl
    implements Exporter {
        IConfigurationElement ce;
        ExportClass action;
        int priority = 0;

        public ExporterImpl(IConfigurationElement ce) {
            this.ce = ce;
            String priorityStr = ce.getAttribute("exportPriority");
            if (priorityStr != null) {
                this.priority = Integer.valueOf(priorityStr);
            }
        }

        ExportClass getOrCreate() throws ExportException {
            if (this.action == null) {
                try {
                    this.action = (ExportClass)this.ce.createExecutableExtension("exportAction");
                }
                catch (CoreException e) {
                    throw new ExportException(e);
                }
            }
            return this.action;
        }

        @Override
        public String formatId() {
            return this.ce.getAttribute("formatId");
        }

        @Override
        public String contentTypeId() {
            return this.ce.getAttribute("content_type_id");
        }

        @Override
        public ExportClass exportAction() throws ExportException {
            return this.getOrCreate();
        }

        public String toString() {
            try {
                return "Exporter, formatId=" + this.formatId() + ", contentTypeId=" + this.contentTypeId() + ", class=" + this.getOrCreate().getClass().getCanonicalName();
            }
            catch (ExportException e) {
                return "Exporter, formatId=" + this.formatId() + ", contentTypeId=" + this.contentTypeId();
            }
        }

        @Override
        public int getExportPriority() {
            return this.priority;
        }
    }

    static class FormatImpl
    implements Format {
        IConfigurationElement ce;
        FormatClass formatClass;

        public FormatImpl(IConfigurationElement ce) {
            this.ce = ce;
        }

        FormatClass getOrCreateFormatClass() throws ExportException {
            if (this.formatClass == null) {
                try {
                    this.formatClass = (FormatClass)this.ce.createExecutableExtension("formatClass");
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    throw new ExportException(e);
                }
            }
            return this.formatClass;
        }

        @Override
        public String id() {
            return this.ce.getAttribute("id");
        }

        @Override
        public String label() {
            return this.ce.getAttribute("label");
        }

        @Override
        public String plural() {
            return this.ce.getAttribute("plural");
        }

        @Override
        public ImageDescriptor icon() {
            try {
                String _url = this.ce.getAttribute("icon");
                URL url = new URL(_url);
                return ImageDescriptor.createFromURL((URL)url);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }

        @Override
        public String fileext() {
            return this.ce.getAttribute("fileext");
        }

        @Override
        public Class<?> writerClass() throws ClassNotFoundException {
            String className = this.ce.getAttribute("writerClass");
            return Class.forName(className);
        }

        @Override
        public Class<?> readerClass() throws ClassNotFoundException {
            String className = this.ce.getAttribute("readerClass");
            return Class.forName(className);
        }

        @Override
        public boolean isGroupFormat() {
            return "true".equals(this.ce.getAttribute("isGroupFormat"));
        }

        @Override
        public boolean isContainerFormat() {
            return "true".equals(this.ce.getAttribute("isContainerFormat"));
        }

        @Override
        public boolean isAttachable() {
            return "true".equals(this.ce.getAttribute("isAttachable"));
        }

        @Override
        public boolean mergeGroupFormatDefault() {
            return "true".equals(this.ce.getAttribute("mergeGroupDefault"));
        }

        @Override
        public boolean isAlwaysPublished() {
            return "true".equals(this.ce.getAttribute("isAlwaysPublished"));
        }

        @Override
        public boolean isLinkContainer() {
            return "true".equals(this.ce.getAttribute("isLinkContainer"));
        }

        @Override
        public RecordType options(ExportContext context) throws ExportException {
            return this.getOrCreateFormatClass().options(context);
        }

        @Override
        public List<String> validate(ExportContext context, Variant options) throws ExportException {
            return this.getOrCreateFormatClass().validate(context, options);
        }

        @Override
        public void fillDefaultPrefs(ExportContext ctx, Variant options) throws ExportException {
            this.getOrCreateFormatClass().fillDefaultPrefs(ctx, options);
        }

        public String toString() {
            try {
                return "Format, id=" + this.id() + ", fileext=" + this.fileext() + ", label=" + this.label() + ", class=" + this.getOrCreateFormatClass().getClass().getCanonicalName();
            }
            catch (ExportException e) {
                return "Format, id=" + this.id() + ", fileext=" + this.fileext() + ", label=" + this.label();
            }
        }

        @Override
        public Object createFile(ExportContext context, File outputFile, Variant options) throws ExportException {
            return this.getOrCreateFormatClass().createFile(context, outputFile, options);
        }

        @Override
        public Object openFile(ExportContext context, File inputFile, Variant options) throws ExportException {
            return this.getOrCreateFormatClass().openFile(context, inputFile, options);
        }

        @Override
        public void closeFile(ExportContext context, Object handle) throws ExportException {
            this.getOrCreateFormatClass().closeFile(context, handle);
        }

        @Override
        public void addAttachment(ExportContext context, Object handle, List<Content> attachments) throws ExportException {
            this.getOrCreateFormatClass().addAttachment(context, handle, attachments);
        }

        @Override
        public FormatClass formatActions() throws ExportException {
            return this.getOrCreateFormatClass();
        }

        @Override
        public void savePref(Variant options, Preferences contentScopeNode, Preferences workbenchScopeNode) throws ExportException {
            this.getOrCreateFormatClass().savePref(options, contentScopeNode, workbenchScopeNode);
        }

        @Override
        public void loadPref(Variant options, Preferences contentScopeNode, Preferences workbenchScopeNode) throws ExportException {
            this.getOrCreateFormatClass().loadPref(options, contentScopeNode, workbenchScopeNode);
        }
    }

    static class ImporterImpl
    implements Importer {
        IConfigurationElement ce;

        public ImporterImpl(IConfigurationElement ce) {
            this.ce = ce;
        }

        @Override
        public String formatId() {
            return this.ce.getAttribute("formatId");
        }

        @Override
        public String contentTypeId() {
            return this.ce.getAttribute("content_type_id");
        }

        @Override
        public ImportAction importAction() throws ExportException {
            try {
                return (ImportAction)this.ce.createExecutableExtension("exportAction");
            }
            catch (CoreException e) {
                throw new ExportException(e);
            }
        }

        public String toString() {
            return "Importer, formatId=" + this.formatId() + ", contentTypeId=" + this.contentTypeId();
        }
    }

    public static class PublisherImpl
    implements Publisher {
        IConfigurationElement ce;
        PublisherClass publisherClass;

        public PublisherImpl(IConfigurationElement ce) {
            this.ce = ce;
        }

        PublisherClass getOrCreatePublisherClass() throws ExportException {
            if (this.publisherClass == null) {
                try {
                    this.publisherClass = (PublisherClass)this.ce.createExecutableExtension("publisherClass");
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    throw new ExportException(e);
                }
            }
            return this.publisherClass;
        }

        @Override
        public String id() {
            return this.ce.getAttribute("id");
        }

        @Override
        public String label() {
            return this.ce.getAttribute("label");
        }

        @Override
        public PublisherClass publisherClass() throws ExportException {
            return this.getOrCreatePublisherClass();
        }

        public String toString() {
            return this.label();
        }
    }
}

