/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.utils;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import org.simantics.g2d.connection.ConnectionEntity;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.DataElementMap;
import org.simantics.g2d.diagram.handler.RelationshipHandler;
import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.TerminalTopology;
import org.simantics.g2d.elementclass.FlagHandler;

public class TopologicalSelectionExpander {
    public static final boolean DEBUG = false;
    IDiagram diagram;
    Set<IElement> startSelection;
    Set<IElement> resultSelection;
    Set<ConnectionEntity> processedConnections = new HashSet<ConnectionEntity>();
    Topology topology;
    DataElementMap dem;

    public static Set<IElement> expandSelection(IDiagram diagram, Set<IElement> elements) {
        return new TopologicalSelectionExpander(diagram, elements).expanded();
    }

    public TopologicalSelectionExpander(IDiagram diagram, Set<IElement> startSelection) {
        assert (diagram != null);
        this.diagram = diagram;
        this.startSelection = startSelection;
        this.resultSelection = new HashSet<IElement>(startSelection);
        this.topology = diagram.getDiagramClass().getAtMostOneItemOfClass(Topology.class);
        this.dem = diagram.getDiagramClass().getAtMostOneItemOfClass(DataElementMap.class);
    }

    public Set<IElement> expandedIfChanged() {
        Set<IElement> result = this.expanded();
        if (result.equals(this.startSelection)) {
            return null;
        }
        return result;
    }

    public Set<IElement> expanded() {
        if (this.topology == null || this.dem == null || this.startSelection.isEmpty()) {
            return this.startSelection;
        }
        ArrayDeque<IElement> work = new ArrayDeque<IElement>(this.startSelection.size() + 4);
        work.addAll(this.startSelection);
        boolean connectionPartsSelected = false;
        for (IElement e : work) {
            Set<IElement> connectionParts;
            IElement connection = TopologicalSelectionExpander.getConnectionOfConnectionPart(e);
            if (connection == null || (connectionParts = TopologicalSelectionExpander.getAllConnectionEntityParts(e)).isEmpty()) continue;
            this.resultSelection.add(connection);
            this.resultSelection.removeAll(connectionParts);
            connectionPartsSelected = true;
        }
        if (!connectionPartsSelected) {
            while (!work.isEmpty()) {
                boolean bl;
                IElement e;
                e = (IElement)work.poll();
                boolean bl2 = bl = this.expandConnection(e, work) || this.expandNode(e, work);
            }
        }
        return this.resultSelection;
    }

    boolean expandConnection(IElement connection, Queue<IElement> workQueue) {
        ConnectionEntity ce = (ConnectionEntity)connection.getHint(ElementHints.KEY_CONNECTION_ENTITY);
        if (ce == null) {
            return false;
        }
        if (!this.processedConnections.add(ce)) {
            return true;
        }
        ArrayList<Topology.Connection> terminals = new ArrayList<Topology.Connection>();
        ce.getTerminalConnections(terminals);
        for (Topology.Connection terminal : terminals) {
            if (!this.resultSelection.add(terminal.node)) continue;
        }
        return true;
    }

    boolean expandNode(IElement e, Queue<IElement> workQueue) {
        RelationshipHandler rh;
        TerminalTopology tt = e.getElementClass().getAtMostOneItemOfClass(TerminalTopology.class);
        if (tt == null) {
            return false;
        }
        ArrayList<Topology.Terminal> terminals = new ArrayList<Topology.Terminal>();
        tt.getTerminals(e, terminals);
        ArrayList<Topology.Connection> connections = new ArrayList<Topology.Connection>();
        for (Topology.Terminal terminal : terminals) {
            this.topology.getConnections(e, terminal, connections);
        }
        for (Topology.Connection connection : connections) {
            IElement conn = TopologicalSelectionExpander.getConnectionEntityConnection(connection.edge);
            if (conn == null) continue;
            this.resultSelection.add(conn);
        }
        boolean expanded = !connections.isEmpty();
        FlagHandler fh = e.getElementClass().getAtMostOneItemOfClass(FlagHandler.class);
        if (fh == null && (rh = this.diagram.getDiagramClass().getAtMostOneItemOfClass(RelationshipHandler.class)) != null) {
            for (RelationshipHandler.Relation rel : rh.getRelations(this.diagram, e, new ArrayList<RelationshipHandler.Relation>())) {
                if (rel.getSubject() instanceof IElement) {
                    expanded |= this.resultSelection.add((IElement)rel.getSubject());
                }
                if (!(rel.getObject() instanceof IElement)) continue;
                expanded |= this.resultSelection.add((IElement)rel.getObject());
            }
        }
        return expanded;
    }

    static IElement getConnectionOfConnectionPart(IElement e) {
        ConnectionEntity ce = (ConnectionEntity)e.getHint(ElementHints.KEY_CONNECTION_ENTITY);
        if (ce == null) {
            return null;
        }
        IElement c = ce.getConnection();
        if (c == e) {
            return null;
        }
        return c;
    }

    static IElement getConnectionEntityConnection(IElement e) {
        ConnectionEntity ce = (ConnectionEntity)e.getHint(ElementHints.KEY_CONNECTION_ENTITY);
        if (ce == null) {
            return null;
        }
        return ce.getConnection();
    }

    static Set<IElement> getAllConnectionEntityParts(IElement e) {
        ConnectionEntity ce = (ConnectionEntity)e.getHint(ElementHints.KEY_CONNECTION_ENTITY);
        if (ce == null) {
            return Collections.emptySet();
        }
        HashSet<IElement> result = new HashSet<IElement>();
        result.add(e);
        ce.getBranchPoints(result);
        ce.getSegments(result);
        return result;
    }
}

