/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.utils;

import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.scenegraph.g2d.events.Event;
import org.simantics.scenegraph.g2d.events.command.Command;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.scenegraph.g2d.events.command.Commands;
import org.simantics.utils.datastructures.Callable;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;

public class CanvasUtils {
    public static void sendCommand(ICanvasContext ctx, String commandId) {
        CanvasUtils.sendCommand(ctx, new Command(commandId));
    }

    public static void sendCommand(ICanvasContext ctx, Command cmd) {
        CommandEvent e = new CommandEvent((Object)ctx, System.currentTimeMillis(), cmd);
        ctx.getEventQueue().queueEvent((Event)e);
    }

    public static void scheduleZoomToFit(IThreadWorkQueue swtThread, Callable<Boolean> disposed, ICanvasContext canvasContext, IDiagram diagramToFit) {
        CanvasUtils.scheduleZoomToFit(swtThread, disposed, canvasContext, diagramToFit, true);
    }

    public static void scheduleZoomToFit(IThreadWorkQueue swtThread, final Callable<Boolean> disposed, final ICanvasContext canvasContext, final IDiagram diagramToFit, boolean zoomToFit) {
        if (diagramToFit == null) {
            throw new IllegalStateException("source diagram is null");
        }
        Boolean canvasZoomToFit = (Boolean)canvasContext.getHintStack().getHint(DiagramHints.KEY_INITIAL_ZOOM_TO_FIT);
        diagramToFit.setHint(Hints.KEY_DISABLE_PAINTING, Boolean.TRUE);
        if (zoomToFit && !Boolean.FALSE.equals(canvasZoomToFit)) {
            diagramToFit.setHint(DiagramHints.KEY_INITIAL_ZOOM_TO_FIT, Boolean.TRUE);
        }
        ThreadUtils.asyncExec((IThreadWorkQueue)swtThread, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (((Boolean)disposed.call()).booleanValue() || canvasContext.isDisposed()) {
                    return;
                }
                ThreadUtils.asyncExec((IThreadWorkQueue)canvasContext.getThreadAccess(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (((Boolean)disposed.call()).booleanValue() || canvasContext.isDisposed()) {
                            return;
                        }
                        Boolean zoomToFit = (Boolean)diagramToFit.removeHint(DiagramHints.KEY_INITIAL_ZOOM_TO_FIT);
                        diagramToFit.removeHint(Hints.KEY_DISABLE_PAINTING);
                        if (Boolean.TRUE.equals(zoomToFit)) {
                            CanvasUtils.sendCommand(canvasContext, Commands.ZOOM_TO_FIT);
                        }
                        CanvasUtils.sendCommand(canvasContext, Commands.ENABLE_PAINTING);
                    }
                });
            }
        });
    }
}

