/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.tooltip;

import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.Clickable;
import org.simantics.g2d.element.handler.impl.AbstractClickable;
import org.simantics.g2d.tooltip.BaseTooltipParticipant;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;

public class TooltipParticipant
extends BaseTooltipParticipant
implements IDiagram.CompositionListener {
    private final ElementHoverListener listener = new ElementHoverListener();

    @Override
    protected void onDiagramSet(IDiagram newValue, IDiagram oldValue) {
        if (oldValue == newValue) {
            return;
        }
        if (oldValue != null) {
            for (IElement e : oldValue.getElements()) {
                this.removeElement(e);
            }
            oldValue.removeCompositionListener(this);
        }
        if (newValue != null) {
            for (IElement e : newValue.getElements()) {
                this.addElement(e);
            }
            newValue.addCompositionListener(this);
        }
    }

    @Override
    public void onElementAdded(IDiagram d, IElement e) {
        this.addElement(e);
    }

    @Override
    public void onElementRemoved(IDiagram d, IElement e) {
        this.removeElement(e);
    }

    private void addElement(IElement e) {
        e.addKeyHintListener(AbstractClickable.PRESS_STATUS_KEY, this.listener);
    }

    private void removeElement(IElement e) {
        e.removeKeyHintListener(AbstractClickable.PRESS_STATUS_KEY, this.listener);
    }

    class ElementHoverListener
    implements IHintListener {
        ElementHoverListener() {
        }

        public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
            IElement element = (IElement)sender;
            Clickable.PressStatus status = (Clickable.PressStatus)((Object)newValue);
            if (status == Clickable.PressStatus.HOVER) {
                TooltipParticipant.this.showTooltipFor(element);
            } else {
                TooltipParticipant.this.hideTooltip();
            }
        }

        public void hintRemoved(IHintObservable sender, IHintContext.Key key, Object oldValue) {
        }
    }
}

