/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.routing.algorithm1;

import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.simantics.g2d.routing.Connection;
import org.simantics.g2d.routing.IRouterOld;
import org.simantics.g2d.routing.Obstacle;
import org.simantics.g2d.routing.algorithm1.Rectangle;

public class RouterOld
implements IRouterOld {
    Map<Connection, Path2D> connections = new HashMap<Connection, Path2D>();
    Set<Obstacle> obstacles = new HashSet<Obstacle>();
    boolean dirty = false;

    @Override
    public void addObstacle(Obstacle obstacle) {
        this.obstacles.add(obstacle);
        this.dirty = true;
    }

    @Override
    public void removeObstacle(Obstacle obstacle) {
        this.obstacles.remove(obstacle);
        this.dirty = true;
    }

    @Override
    public void addConnection(Connection connection) {
        this.connections.put(connection, null);
        this.dirty = true;
    }

    @Override
    public void removeConnection(Connection connection) {
        this.connections.remove(connection);
        this.dirty = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Path2D getPath(Connection connection) {
        if (this.dirty) {
            RouterOld routerOld = this;
            synchronized (routerOld) {
                if (this.dirty) {
                    long beginTime = System.nanoTime();
                    this.update();
                    long endTime = System.nanoTime();
                    System.out.println(String.valueOf((double)(endTime - beginTime) * 1.0E-6) + "ms");
                    this.dirty = false;
                }
            }
        }
        return this.connections.get(connection);
    }

    private void update() {
        ArrayList<Rectangle> rectangles = new ArrayList<Rectangle>(this.obstacles.size());
        for (Obstacle obs : this.obstacles) {
            Rectangle2D shape = obs.shape;
            rectangles.add(new Rectangle(shape.getMinX(), shape.getMinY(), shape.getMaxX(), shape.getMaxY()));
        }
        Connection[] carray = this.connections.keySet().toArray(new Connection[this.connections.size()]);
        Arrays.sort(carray, new Comparator<Connection>(){

            @Override
            public int compare(Connection o1, Connection o2) {
                double l2;
                double l1 = o1.minLength();
                if (l1 < (l2 = o2.minLength())) {
                    return -1;
                }
                if (l1 > l2) {
                    return 1;
                }
                if (o1.routePath.length < o2.routePath.length) {
                    return -1;
                }
                if (o1.routePath.length > o2.routePath.length) {
                    return 1;
                }
                int i = 0;
                while (i < o1.routePath.length) {
                    if (o1.routePath[i] < o2.routePath[i]) {
                        return -1;
                    }
                    if (o1.routePath[i] > o2.routePath[i]) {
                        return 1;
                    }
                    ++i;
                }
                return 0;
            }
        });
        ArrayList lines = new ArrayList(this.connections.size());
        Connection[] connectionArray = carray;
        int n = carray.length;
        int n2 = 0;
        while (n2 < n) {
            Connection connection = connectionArray[n2];
            ++n2;
        }
    }
}

