/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.routing.algorithm1;

import gnu.trove.THashMap;
import gnu.trove.TObjectIdentityHashingStrategy;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.simantics.g2d.routing.IGraphModel;
import org.simantics.g2d.routing.IRouter;
import org.simantics.g2d.routing.Terminal;
import org.simantics.g2d.routing.algorithm1.Penalty;
import org.simantics.g2d.routing.algorithm1.PenaltyRectangle;
import org.simantics.g2d.routing.algorithm1.Rectangle;
import org.simantics.g2d.routing.algorithm1.StaticRouter;
import org.simantics.g2d.routing.spatial.IRectangleProcedure;
import org.simantics.g2d.routing.spatial.RTree;

public class Router
implements IRouter {
    TObjectIdentityHashingStrategy<Object> HASHING_STRATEGY = new TObjectIdentityHashingStrategy();
    THashMap<Object, PenaltyRectangle> oldObstacles;
    THashMap<Object, ConnectionInfo> oldConnections = new THashMap(this.HASHING_STRATEGY);

    /*
     * WARNING - void declaration
     */
    @Override
    public void update(IGraphModel model) {
        double[] coords = new double[6];
        RTree rtree = new RTree();
        RTree modifications = null;
        if (this.oldObstacles == null) {
            this.oldObstacles = new THashMap(this.HASHING_STRATEGY);
            for (Object obstacle : model.getObstacles()) {
                Rectangle2D rectangle2D = model.getObstacleShape(obstacle);
                PenaltyRectangle pRect = new PenaltyRectangle(rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D.getMaxX(), rectangle2D.getMaxY(), Penalty.OBSTACLE_PENALTY, Penalty.OBSTACLE_PENALTY);
                rtree.add(pRect, pRect);
                this.oldObstacles.put(obstacle, (Object)pRect);
            }
        } else {
            modifications = new RTree();
            THashMap newObstacles = new THashMap(this.HASHING_STRATEGY);
            for (Object obstacle : model.getObstacles()) {
                Iterator rect2d = model.getObstacleShape(obstacle);
                PenaltyRectangle oldRect = (PenaltyRectangle)this.oldObstacles.remove(obstacle);
                if (oldRect != null && ((RectangularShape)((Object)rect2d)).getMinX() == oldRect.x0 && ((RectangularShape)((Object)rect2d)).getMaxX() == oldRect.x1 && ((RectangularShape)((Object)rect2d)).getMinY() == oldRect.y0 && ((RectangularShape)((Object)rect2d)).getMaxY() == oldRect.y1) {
                    newObstacles.put(obstacle, (Object)oldRect);
                    rtree.add(oldRect, oldRect);
                    continue;
                }
                PenaltyRectangle pRect = new PenaltyRectangle(((RectangularShape)((Object)rect2d)).getMinX(), ((RectangularShape)((Object)rect2d)).getMinY(), ((RectangularShape)((Object)rect2d)).getMaxX(), ((RectangularShape)((Object)rect2d)).getMaxY(), Penalty.OBSTACLE_PENALTY, Penalty.OBSTACLE_PENALTY);
                rtree.add(pRect, pRect);
                newObstacles.put(obstacle, (Object)pRect);
                modifications.add(pRect, pRect);
                if (oldRect == null) continue;
                modifications.add(oldRect, oldRect);
            }
            this.oldObstacles = newObstacles;
        }
        THashMap newConnections = new THashMap(this.HASHING_STRATEGY);
        Collection<Object> connections = model.getConnections();
        if (modifications != null) {
            for (Object e : connections) {
                ConnectionInfo oldInfo = (ConnectionInfo)this.oldConnections.remove(e);
                if (oldInfo == null) continue;
                newConnections.put(e, (Object)oldInfo);
            }
            for (ConnectionInfo connectionInfo : this.oldConnections.values()) {
                modifications.add(connectionInfo.bounds, connectionInfo);
            }
        }
        boolean bl = false;
        block8: for (Object c : connections) {
            Path2D path;
            void var7_15;
            ConnectionInfo info;
            Terminal begin = model.getBeginTerminal(c);
            double[] routePoints = model.getRoutePoints(c);
            Terminal end = model.getEndTerminal(c);
            int hash = (begin == null ? 0 : begin.hashCode()) + 31 * ((end == null ? 0 : end.hashCode()) + 31 * Arrays.hashCode(routePoints));
            if (modifications != null && (info = (ConnectionInfo)newConnections.get(c)) != null) {
                if (hash == info.hash && !modifications.intersects(info)) {
                    newConnections.put(c, (Object)info);
                    continue;
                }
                modifications.add(info.bounds, info);
            }
            ++var7_15;
            double x0 = Double.POSITIVE_INFINITY;
            double y0 = Double.POSITIVE_INFINITY;
            double x1 = Double.NEGATIVE_INFINITY;
            double y1 = Double.NEGATIVE_INFINITY;
            if (begin != null) {
                if (begin.x < x0) {
                    x0 = begin.x;
                } else if (begin.x > x1) {
                    x1 = begin.x;
                }
                if (begin.y < y0) {
                    y0 = begin.x;
                } else if (begin.y > y1) {
                    y1 = begin.x;
                }
            }
            if (end != null) {
                if (end.x < x0) {
                    x0 = end.x;
                } else if (end.x > x1) {
                    x1 = end.x;
                }
                if (end.y < y0) {
                    y0 = end.x;
                } else if (end.y > y1) {
                    y1 = end.x;
                }
            }
            int i = 0;
            while (i < routePoints.length) {
                double x = routePoints[i];
                if (x < x0) {
                    x0 = x;
                } else if (x > x1) {
                    x1 = x;
                }
                double y = routePoints[i + 1];
                if (y < y0) {
                    y0 = x;
                } else if (y > y1) {
                    y1 = x;
                }
                i += 2;
            }
            final HashSet<PenaltyRectangle> rectangles = new HashSet<PenaltyRectangle>();
            rtree.search(new Rectangle(x0, y0, x1, y1), new IRectangleProcedure(){

                @Override
                public void call(double x0, double y0, double x1, double y1, Object value) {
                    rectangles.add((PenaltyRectangle)value);
                }
            });
            while ((path = new StaticRouter(rectangles).route(begin, routePoints, end)) != null) {
                Rectangle2D rect = path.getBounds2D();
                boolean contained = true;
                if (rect.getMinX() < x0) {
                    x0 = rect.getMinX();
                    contained = false;
                }
                if (rect.getMaxX() > x1) {
                    x1 = rect.getMaxX();
                    contained = false;
                }
                if (rect.getMinY() < y0) {
                    y0 = rect.getMinY();
                    contained = false;
                }
                if (rect.getMaxY() > y1) {
                    y1 = rect.getMaxY();
                    contained = false;
                }
                final boolean[] ff = new boolean[]{true};
                if (!contained) {
                    rtree.search(new Rectangle(x0, y0, x1, y1), new IRectangleProcedure(){

                        @Override
                        public void call(double x0, double y0, double x1, double y1, Object value) {
                            if (!rectangles.contains(value)) {
                                rectangles.add((PenaltyRectangle)value);
                                ff[0] = false;
                            }
                        }
                    });
                }
                if (!ff[0]) continue;
                model.setPath(c, path);
                PathIterator it = path.getPathIterator(new AffineTransform());
                double curX = 0.0;
                double curY = 0.0;
                double newX = 0.0;
                double newY = 0.0;
                while (!it.isDone()) {
                    switch (it.currentSegment(coords)) {
                        case 0: {
                            curX = coords[0];
                            curY = coords[1];
                            break;
                        }
                        case 1: {
                            newX = coords[0];
                            newY = coords[1];
                            PenaltyRectangle pRect = newX == curX ? new PenaltyRectangle(curX - 10.0, Math.min(curY, newY), curX + 10.0, Math.max(curY, newY), Penalty.CONNECTION_CROSS_PENALTY, Penalty.CONNECTION_SIDE_PENALTY) : new PenaltyRectangle(Math.min(curX, newX), curY - 10.0, Math.max(curX, newX), curY + 10.0, Penalty.CONNECTION_SIDE_PENALTY, Penalty.CONNECTION_CROSS_PENALTY);
                            rtree.add(pRect, pRect);
                            curX = newX;
                            curY = newY;
                        }
                    }
                    it.next();
                }
                ConnectionInfo info2 = new ConnectionInfo(x0, y0, x1, y1, Rectangle.of(path.getBounds2D()), hash);
                if (modifications != null) {
                    modifications.add(info2.bounds, info2);
                }
                newConnections.put(c, (Object)info2);
                continue block8;
            }
        }
        this.oldConnections = newConnections;
    }

    static class ConnectionInfo
    extends Rectangle {
        Rectangle bounds;
        int hash;

        public ConnectionInfo(double x0, double y0, double x1, double y1, Rectangle bounds, int hash) {
            super(x0, y0, x1, y1);
            this.bounds = bounds;
            this.hash = hash;
        }
    }
}

