/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.routing.algorithm1;

import org.simantics.g2d.routing.algorithm1.StaticRouter;

public class Penalty {
    static final double BEND_PENALTY = 1.0;
    static final double CONNECTION_MARGINAL = 10.0;
    static final StaticRouter.Cost INFINITE_COST = new StaticRouter.Cost(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    static final Penalty OBSTACLE_PENALTY = new Penalty(20.0, 0.0);
    static final Penalty CONNECTION_SIDE_PENALTY = new Penalty(10.0, 0.0);
    static final Penalty CONNECTION_CROSS_PENALTY = new Penalty(0.4, 20.0);
    double penalty;
    double minDistance;

    public Penalty(double penalty, double minDistance) {
        this.penalty = penalty;
        this.minDistance = minDistance;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.minDistance);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.penalty);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Penalty other = (Penalty)obj;
        if (Double.doubleToLongBits(this.minDistance) != Double.doubleToLongBits(other.minDistance)) {
            return false;
        }
        return Double.doubleToLongBits(this.penalty) == Double.doubleToLongBits(other.penalty);
    }
}

