/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.participant;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.canvas.impl.SGNodeReflection;
import org.simantics.g2d.participant.GridPainter;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.scenegraph.g2d.events.command.Commands;
import org.simantics.scenegraph.g2d.nodes.RulerNode;
import org.simantics.utils.datastructures.hints.HintListenerAdapter;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.page.MarginUtils;

public class RulerPainter
extends AbstractCanvasParticipant {
    public static final int PAINT_PRIORITY = 2147482647;
    public static final double RULER_WIDTH = 20.0;
    public static final MarginUtils.Margin RULER_MARGIN5 = MarginUtils.marginOf((double)5.0, (double)20.0, (double)0.0);
    public static final MarginUtils.Margin RULER_MARGIN2 = MarginUtils.marginOf((double)2.0, (double)20.0, (double)0.0);
    public static final MarginUtils.Margins RULER_MARINGS5 = new MarginUtils.Margins(RULER_MARGIN5, MarginUtils.MARGIN5, RULER_MARGIN5, MarginUtils.MARGIN5);
    public static final MarginUtils.Margins RULER_MARINGS2 = new MarginUtils.Margins(RULER_MARGIN2, MarginUtils.MARGIN2, RULER_MARGIN2, MarginUtils.MARGIN2);
    public static final IHintContext.Key KEY_RULER_ENABLED = new IHintContext.KeyOf(Boolean.class, "RULER_ENABLED");
    public static final IHintContext.Key KEY_RULER_BACKGROUND_COLOR = new IHintContext.KeyOf(Color.class, "RULER_BACKGROUND_COLOR");
    public static final IHintContext.Key KEY_RULER_TEXT_COLOR = new IHintContext.KeyOf(Color.class, "RULER_TEXT_COLOR");
    public static Color DEFAULT_RULER_BACKGROUND_COLOR = new Color(192, 192, 192, 192);
    public static Color DEFAULT_RULER_TEXT_COLOR = Color.BLACK;
    IHintListener hintListener = new HintListenerAdapter(){

        public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
            ICanvasContext cc = RulerPainter.this.getContext();
            if (cc != null) {
                RulerPainter.this.updateNode();
                cc.getContentContext().setDirty();
            }
        }
    };
    private final Composite transparency = AlphaComposite.SrcOver.derive(0.75f);
    protected RulerNode node = null;

    @Override
    public void addedToContext(ICanvasContext ctx) {
        super.addedToContext(ctx);
        this.getHintStack().addKeyHintListener(this.getThread(), KEY_RULER_ENABLED, this.hintListener);
        this.getHintStack().addKeyHintListener(this.getThread(), KEY_RULER_BACKGROUND_COLOR, this.hintListener);
        this.getHintStack().addKeyHintListener(this.getThread(), KEY_RULER_TEXT_COLOR, this.hintListener);
        this.getHintStack().addKeyHintListener(this.getThread(), GridPainter.KEY_GRID_SIZE, this.hintListener);
        this.getHintStack().addKeyHintListener(this.getThread(), Hints.KEY_DISABLE_PAINTING, this.hintListener);
    }

    @Override
    public void removedFromContext(ICanvasContext ctx) {
        this.getHintStack().removeKeyHintListener(this.getThread(), KEY_RULER_ENABLED, this.hintListener);
        this.getHintStack().removeKeyHintListener(this.getThread(), KEY_RULER_BACKGROUND_COLOR, this.hintListener);
        this.getHintStack().removeKeyHintListener(this.getThread(), KEY_RULER_TEXT_COLOR, this.hintListener);
        this.getHintStack().removeKeyHintListener(this.getThread(), GridPainter.KEY_GRID_SIZE, this.hintListener);
        this.getHintStack().removeKeyHintListener(this.getThread(), Hints.KEY_DISABLE_PAINTING, this.hintListener);
        super.removedFromContext(ctx);
    }

    @SGNodeReflection.SGInit
    public void initSG(G2DParentNode parent) {
        this.node = (RulerNode)parent.addNode("ruler", RulerNode.class);
        this.node.setZIndex(2147482647);
        this.updateNode();
    }

    @SGNodeReflection.SGCleanup
    public void cleanupSG() {
        this.node.remove();
    }

    void updateNode() {
        this.node.setEnabled(Boolean.valueOf(this.isPaintingEnabled()));
        this.node.setGridSize(this.getGridSize());
    }

    private double getGridSize() {
        Double d = (Double)this.getHint(GridPainter.KEY_GRID_SIZE);
        return d != null ? d : 1.0;
    }

    boolean isPaintingEnabled() {
        boolean enabled = this.isEnabled();
        Boolean globalDisable = (Boolean)this.getHint(Hints.KEY_DISABLE_PAINTING);
        return enabled && !Boolean.TRUE.equals(globalDisable);
    }

    public boolean isEnabled() {
        Boolean b = (Boolean)this.getHint(KEY_RULER_ENABLED);
        return !Boolean.FALSE.equals(b);
    }

    public Color getRulerTextColor() {
        Color c = (Color)this.getHint(KEY_RULER_TEXT_COLOR);
        if (c != null) {
            return c;
        }
        return DEFAULT_RULER_TEXT_COLOR;
    }

    public Color getRulerBackgroundColor() {
        Color c = (Color)this.getHint(KEY_RULER_BACKGROUND_COLOR);
        if (c != null) {
            return c;
        }
        return DEFAULT_RULER_BACKGROUND_COLOR;
    }

    public void setEnabled(boolean enabled) {
        this.node.setEnabled(Boolean.valueOf(enabled));
        this.setHint(KEY_RULER_ENABLED, enabled);
    }

    public void setRulerTextColor(Color c) {
        this.setHint(KEY_RULER_TEXT_COLOR, c);
    }

    public void setRulerBackgroundColor(Color c) {
        this.setHint(KEY_RULER_BACKGROUND_COLOR, c);
    }

    @EventHandlerReflection.EventHandler(priority=0)
    public boolean handleKeyEvent(CommandEvent e) {
        if (e.command.equals((Object)Commands.RULER_ENABLE)) {
            this.setEnabled(true);
            return true;
        }
        if (e.command.equals((Object)Commands.RULER_DISABLE)) {
            this.setEnabled(false);
            return true;
        }
        if (e.command.equals((Object)Commands.RULER_TOGGLE)) {
            this.setEnabled(!this.isEnabled());
            return true;
        }
        return false;
    }
}

