/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.image.impl;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.util.Arrays;
import java.util.EnumSet;
import org.simantics.g2d.image.Image;
import org.simantics.g2d.image.impl.ImageProxy;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DParentNode;

public class Shadow
extends ImageProxy
implements Image {
    public static final ShadowParameters SHADOW = new ShadowParameters(0.5, Color.BLACK, 2);
    public final ShadowParameters shadow;
    Point2D size;
    ConvolveOp horiz;
    ConvolveOp vert;
    int shadowSizeX;
    int shadowSizeY;
    EnumSet<Image.Feature> feats;
    public Image.ImageListener origListener;

    public Shadow(Image source, ShadowParameters shadow) {
        super(source);
        this.shadow = shadow;
        this.shadowSizeX = shadow.size;
        this.shadowSizeY = shadow.size;
        this.horiz = this.createBlurOp(shadow.size, 1);
        this.vert = this.createBlurOp(1, shadow.size);
        this.feats = source.getFeatures().contains((Object)Image.Feature.Volatile) ? EnumSet.of(Image.Feature.Volatile) : EnumSet.noneOf(Image.Feature.class);
    }

    public Shadow(Image source, ShadowParameters shadow, double width, double height) {
        this(source, shadow);
        this.size = new Point2D.Double(width, height);
        this.shadowSizeX = (int)Math.round((double)shadow.size * width / source.getBounds().getWidth());
        this.shadowSizeY = (int)Math.round((double)shadow.size * height / source.getBounds().getHeight());
        if (this.shadowSizeX < 1) {
            this.shadowSizeX = 1;
        }
        if (this.shadowSizeY < 1) {
            this.shadowSizeY = 1;
        }
        this.horiz = this.createBlurOp(this.shadowSizeX, 1);
        this.vert = this.createBlurOp(1, this.shadowSizeY);
    }

    @Override
    public Rectangle2D getBounds() {
        Rectangle2D rect = this.source.getBounds();
        return new Rectangle2D.Double(rect.getX() - (double)this.shadowSizeX, rect.getY() - (double)this.shadowSizeY, rect.getWidth() + (double)(this.shadowSizeX * 2), rect.getHeight() + (double)(this.shadowSizeY * 2));
    }

    private BufferedImage createImage() {
        Rectangle2D origBounds = this.source.getBounds();
        double width = this.size == null ? origBounds.getWidth() : this.size.getX();
        double height = this.size == null ? origBounds.getHeight() : this.size.getY();
        BufferedImage subject = new BufferedImage((int)Math.ceil(width + (double)(this.shadowSizeX * 2)), (int)Math.ceil(height + (double)(this.shadowSizeY * 2)), 2);
        Graphics2D g = subject.createGraphics();
        g.translate(this.shadowSizeX, this.shadowSizeY);
        if (this.size != null) {
            g.scale(this.size.getX() / origBounds.getWidth(), this.size.getY() / origBounds.getHeight());
        }
        g.translate(-origBounds.getMinX(), -origBounds.getMinY());
        Rectangle2D.Double bounds = new Rectangle2D.Double(0.0, 0.0, subject.getWidth(), subject.getHeight());
        g.dispose();
        return subject;
    }

    private BufferedImage createShadowMask(BufferedImage image) {
        BufferedImage mask = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D g2d = mask.createGraphics();
        g2d.drawImage((java.awt.Image)image, 0, 0, null);
        g2d.setComposite(AlphaComposite.getInstance(5, (float)this.shadow.alpha));
        g2d.setColor(this.shadow.color);
        g2d.fillRect(0, 0, image.getWidth(), image.getHeight());
        g2d.dispose();
        return mask;
    }

    public BufferedImage createShadow() {
        BufferedImage i1 = this.createImage();
        BufferedImage i2 = new BufferedImage(i1.getWidth(), i1.getHeight(), 2);
        BufferedImage shadowMask = this.createShadowMask(i1);
        this.horiz.filter(shadowMask, i2);
        this.vert.filter(i2, shadowMask);
        return shadowMask;
    }

    private ConvolveOp createBlurOp(int width, int height) {
        float[] data = new float[width * height];
        float value = 1.0f / (float)(width * height);
        Arrays.fill(data, value);
        return new ConvolveOp(new Kernel(width, height, data));
    }

    @Override
    public Node init(G2DParentNode parent) {
        return null;
    }

    @Override
    public EnumSet<Image.Feature> getFeatures() {
        return this.feats;
    }

    public static final class ShadowParameters {
        public final double alpha;
        public final Color color;
        public final int size;

        public ShadowParameters(double alpha, Color color, int size) {
            this.alpha = alpha;
            this.color = color;
            this.size = size;
        }
    }
}

