/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.image.impl;

import java.awt.geom.AffineTransform;
import java.util.EnumSet;
import org.simantics.g2d.image.Image;
import org.simantics.g2d.image.impl.ImageProxy;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DParentNode;

public class BufferedImage
extends ImageProxy
implements Image {
    public static final double MAX_DIMENSION = 800.0;
    java.awt.image.BufferedImage raster;
    double rasterResolution = 1.0;
    double maxDimension;
    EnumSet<Image.Feature> caps;

    public BufferedImage(Image source) {
        this(source, 800.0);
    }

    public BufferedImage(Image source, double maxDimension) {
        super(source);
        this.maxDimension = maxDimension;
        boolean vector = source.getFeatures().contains((Object)Image.Feature.Vector);
        boolean vola = source.getFeatures().contains((Object)Image.Feature.Volatile);
        if (vola) {
            source.addImageListener(new Image.ImageListener(){

                @Override
                public void onContentChangedNotification(Image image) {
                    BufferedImage.this.releaseRaster();
                }
            });
            this.caps = EnumSet.of(Image.Feature.Volatile);
        } else {
            this.caps = EnumSet.noneOf(Image.Feature.class);
        }
    }

    private double requiredResolution(AffineTransform af) {
        double reso = Math.max(af.getScaleX(), af.getScaleY());
        return reso *= 1.3;
    }

    private synchronized void releaseRaster() {
        this.raster = null;
    }

    @Override
    public synchronized Node init(G2DParentNode parent) {
        return null;
    }

    @Override
    public EnumSet<Image.Feature> getFeatures() {
        return this.caps;
    }
}

