/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.elementclass.wheel;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.vecmath.Tuple2d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.HandleMouseEvent;
import org.simantics.g2d.element.handler.Heartbeat;
import org.simantics.g2d.element.handler.InternalSize;
import org.simantics.g2d.element.handler.LifeCycle;
import org.simantics.g2d.element.handler.Rotate;
import org.simantics.g2d.element.handler.Stateful;
import org.simantics.g2d.element.handler.impl.AbstractGrabbable;
import org.simantics.utils.datastructures.hints.IHintContext;

public class RotatorHandler
extends AbstractGrabbable
implements HandleMouseEvent,
LifeCycle,
Heartbeat {
    private static final long serialVersionUID = -3588513675880482627L;
    public static final RotatorHandler INSTANCE = new RotatorHandler();
    public static final double STRAY_DISTANCE = 1000.0;
    public double initial_friction = 0.2;
    public double initial_grab_friction = 0.99;
    public double initial_factor = 0.025;
    public double angVelTolerance = 0.5;
    public static final IHintContext.Key KEY_ANG_VEL = new IHintContext.KeyOf(Double.class);
    public static final IHintContext.Key KEY_MIN_POINTERS = new IHintContext.KeyOf(Integer.class);
    public static final IHintContext.Key KEY_GRAB_FRICTION = new IHintContext.KeyOf(Double.class);
    public static final IHintContext.Key KEY_FRICTION = new IHintContext.KeyOf(Double.class);
    public static final IHintContext.Key KEY_FACTOR = new IHintContext.KeyOf(Double.class);

    public RotatorHandler() {
        super(1000.0);
    }

    @Override
    protected void onDrag(AbstractGrabbable.GrabInfo gi, ICanvasContext ctx) {
        IElement e = gi.e;
        Point2D origo = this.getOrigo(e, null);
        Point2D prevPos = gi.prevPosElement;
        Point2D p = gi.dragPosElement;
        Vector2d p0 = new Vector2d(prevPos.getX(), prevPos.getY());
        Vector2d p1 = new Vector2d(p.getX(), p.getY());
        Vector2d f = new Vector2d(p1);
        f.sub((Tuple2d)p0);
        if (f.length() == 0.0) {
            return;
        }
        Vector2d odp0 = new Vector2d(p0.x - origo.getX(), p0.y - origo.getY());
        Vector2d odp1 = new Vector2d(p1.x - origo.getX(), p1.y - origo.getY());
        Vector2d fn = new Vector2d(odp0);
        fn.scale(f.dot(odp0) / odp0.lengthSquared());
        Vector2d ft = new Vector2d(f);
        ft.sub((Tuple2d)fn);
        Vector3d r = new Vector3d(odp0.x, odp0.y, 0.0);
        Vector3d F = new Vector3d(ft.x, ft.y, 0.0);
        Vector3d M = new Vector3d();
        M.cross(r, F);
        if (!this.isGrabbed(e, ctx)) {
            return;
        }
        double deltaAngle = odp0.angle(odp1);
        if (M.z < 0.0) {
            deltaAngle *= -1.0;
        }
        double deltaAngularVelocity = deltaAngle * 20.0;
        this.setAngVel(e, this.getAngVel(e) + deltaAngularVelocity);
        this.modifyValue(e, ctx, deltaAngle *= 0.297);
    }

    @Override
    protected void onGrab(AbstractGrabbable.GrabInfo gi, ICanvasContext ctx) {
    }

    @Override
    protected void onGrabCancel(AbstractGrabbable.GrabInfo gi, ICanvasContext ctx) {
    }

    @Override
    protected boolean onGrabCheck(IElement e, ICanvasContext ctx, int pointerId, Point2D pickPos) {
        return this.isEnabled(e);
    }

    @Override
    protected void onRelease(AbstractGrabbable.GrabInfo gi, ICanvasContext ctx) {
    }

    @Override
    public void heartbeat(IElement e, long time, long deltaTime, ICanvasContext ctx) {
        boolean isGrabbed = this.isGrabbed(e, ctx);
        boolean isMoving = this.isMoving(e);
        boolean isLocked = this.isLocked(e);
        if (!isGrabbed && !isMoving || isLocked) {
            this.setAngVel(e, 0.0);
            return;
        }
        double angVel = this.getAngVel(e);
        if (angVel == 0.0) {
            return;
        }
        if (Math.abs(angVel) < this.angVelTolerance) {
            this.setAngVel(e, 0.0);
            if (!isGrabbed) {
                // empty if block
            }
            return;
        }
        this.modifyValue(e, ctx, (double)deltaTime * angVel * this.getFactor(e) * 0.01);
        double f = isGrabbed ? this.getGrabFriction(e) : this.getFriction(e);
        double dt = (double)deltaTime / 1000.0;
        this.setAngVel(e, angVel *= Math.pow(1.0 - f, dt));
        ctx.getContentContext().setDirty();
    }

    @Override
    public void onElementActivated(IDiagram d, IElement e) {
    }

    @Override
    public void onElementCreated(IElement e) {
        e.setHint(KEY_MIN_POINTERS, 1);
        e.setHint(ElementHints.KEY_VALUE, 0.0);
        e.setHint(KEY_FRICTION, this.initial_friction);
        e.setHint(KEY_FACTOR, this.initial_factor);
        e.setHint(KEY_GRAB_FRICTION, this.initial_grab_friction);
        e.setHint(KEY_ANG_VEL, 0.0);
    }

    @Override
    public void onElementDeactivated(IDiagram d, IElement e) {
    }

    @Override
    public void onElementDestroyed(IElement e) {
    }

    private double getFriction(IElement e) {
        return (Double)e.getHint(KEY_FRICTION);
    }

    private double getGrabFriction(IElement e) {
        return (Double)e.getHint(KEY_GRAB_FRICTION);
    }

    private double getFactor(IElement e) {
        return (Double)e.getHint(KEY_FACTOR);
    }

    private double getValue(IElement e) {
        return (Double)e.getHint(ElementHints.KEY_VALUE);
    }

    private void setValue(IElement e, ICanvasContext ctx, double value) {
        Double min = (Double)e.getHint(ElementHints.KEY_MIN_VALUE);
        Double max = (Double)e.getHint(ElementHints.KEY_MAX_VALUE);
        if (min != null && value < min) {
            value = min;
        }
        if (max != null && value > max) {
            value = max;
        }
        e.setHint(ElementHints.KEY_VALUE, value);
        Point2D origo = this.getOrigo(e, null);
        Rotate r = e.getElementClass().getSingleItem(Rotate.class);
        double angle = r.getAngle(e);
        double targetAngle = Math.IEEEremainder(value, Math.PI * 2);
        double diffrence = targetAngle - angle;
        r.rotate(e, diffrence, origo);
    }

    public Point2D getOrigo(IElement e, Point2D origo) {
        Rectangle2D.Double size = new Rectangle2D.Double();
        InternalSize b = e.getElementClass().getSingleItem(InternalSize.class);
        b.getBounds(e, size);
        if (origo == null) {
            origo = new Point2D.Double(size.getCenterX(), size.getCenterY());
        }
        return origo;
    }

    public synchronized void modifyValue(IElement e, ICanvasContext ctx, double modification) {
        Double position = this.getValue(e);
        double value = position + modification;
        this.setValue(e, ctx, value);
    }

    public int getMinPointers(IElement e) {
        Integer i = (Integer)e.getHint(KEY_MIN_POINTERS);
        if (i == null) {
            return 1;
        }
        return i;
    }

    public double getAngVel(IElement e) {
        Double d = (Double)e.getHint(KEY_ANG_VEL);
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    public void setAngVel(IElement e, double value) {
        e.setHint(KEY_ANG_VEL, value);
    }

    public boolean isGrabbed(IElement e, ICanvasContext ctx) {
        return this.getGrabCount(e, ctx) >= this.getMinPointers(e) || !this.isEnabled(e);
    }

    public boolean isMoving(IElement e) {
        return this.getAngVel(e) != 0.0;
    }

    public boolean isLocked(IElement e) {
        Boolean b = (Boolean)e.getHint(ElementHints.KEY_LOCKED);
        return b == null ? false : b;
    }

    public boolean isEnabled(IElement e) {
        Stateful enabled = e.getElementClass().getAtMostOneItemOfClass(Stateful.class);
        if (enabled == null) {
            return true;
        }
        return enabled.isEnabled(e);
    }

    public boolean isMoveable(IElement e) {
        return true;
    }
}

