/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.elementclass.connection;

import java.awt.Composite;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.simantics.g2d.connection.ConnectionEntity;
import org.simantics.g2d.connection.handler.ConnectionHandler;
import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.Children;
import org.simantics.g2d.element.handler.InternalSize;
import org.simantics.g2d.element.handler.Outline;
import org.simantics.g2d.element.handler.Pick;
import org.simantics.g2d.element.handler.Pick2;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.element.handler.SelectionOutline;
import org.simantics.g2d.element.handler.impl.ConnectionSelectionOutline;
import org.simantics.g2d.element.handler.impl.ParentImpl;
import org.simantics.g2d.element.handler.impl.SimpleElementLayers;
import org.simantics.g2d.element.handler.impl.TextImpl;
import org.simantics.g2d.elementclass.PlainElementPropertySetter;
import org.simantics.g2d.elementclass.connection.EdgeClass;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.nodes.SingleElementNode;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.utils.datastructures.ListenerList;
import org.simantics.utils.datastructures.hints.IHintContext;

public class ConnectionClass {
    public static final ElementClass CLASS = ElementClass.compile(TextImpl.INSTANCE, EdgeClass.FixedTransform.INSTANCE, ConnectionPick.INSTANCE, ConnectionBounds.INSTANCE, ConnectionSelectionOutline.INSTANCE, ConnectionHandlerImpl.INSTANCE, ConnectionChildren.INSTANCE, ParentImpl.INSTANCE, ConnectionSceneGraph.INSTANCE, SimpleElementLayers.INSTANCE, new PlainElementPropertySetter(ElementHints.KEY_SG_NODE)).setId(ConnectionClass.class.getSimpleName());
    private static final ThreadLocal<List<IElement>> perThreadSceneGraphList = new ThreadLocalList();
    private static final ThreadLocal<List<IElement>> perThreadBoundsList = new ThreadLocalList();
    private static final ThreadLocal<List<IElement>> perThreadShapeList = new ThreadLocalList();
    private static final ThreadLocal<List<IElement>> perThreadPickList = new ThreadLocalList();
    private static final IHintContext.Key CHILD_LISTENERS = new IHintContext.KeyOf(ListenerList.class, "CHILD_LISTENERS");

    static final class ConnectionBounds
    implements InternalSize,
    Outline {
        public static final ConnectionBounds INSTANCE = new ConnectionBounds();
        private static final long serialVersionUID = 4232871859964883266L;

        ConnectionBounds() {
        }

        @Override
        public Rectangle2D getBounds(IElement e, Rectangle2D size) {
            ConnectionEntity ce = (ConnectionEntity)e.getHint(ElementHints.KEY_CONNECTION_ENTITY);
            if (ce == null) {
                return size;
            }
            Collection<IElement> parts = (Collection<IElement>)perThreadBoundsList.get();
            parts.clear();
            parts = ce.getSegments(parts);
            if (parts.isEmpty()) {
                return size;
            }
            parts = ce.getBranchPoints(parts);
            Rectangle2D.Double temp = null;
            for (IElement part : parts) {
                Rectangle2D bounds;
                if (ElementUtils.isHidden(part) || (bounds = ElementUtils.getElementBoundsOnDiagram(part, size)) == null) continue;
                if (temp == null) {
                    temp = new Rectangle2D.Double();
                    ((Rectangle2D)temp).setRect(bounds);
                    continue;
                }
                Rectangle2D.union(temp, bounds, temp);
            }
            if (temp != null) {
                if (size == null) {
                    size = temp;
                } else {
                    size.setRect(temp);
                }
            }
            parts.clear();
            return size;
        }

        private Shape getSelectionShape(IElement forPart) {
            for (SelectionOutline so : forPart.getElementClass().getItemsByClass(SelectionOutline.class)) {
                Shape shape = so.getSelectionShape(forPart);
                if (shape == null) continue;
                return shape;
            }
            Shape shape = ElementUtils.getElementShapeOrBoundsOnDiagram(forPart);
            return shape;
        }

        @Override
        public Shape getElementShape(IElement e) {
            ConnectionEntity ce = (ConnectionEntity)e.getHint(ElementHints.KEY_CONNECTION_ENTITY);
            if (ce == null) {
                return new Rectangle2D.Double();
            }
            Collection<IElement> parts = (Collection<IElement>)perThreadShapeList.get();
            if ((parts = ce.getSegments(parts)).isEmpty()) {
                return new Rectangle2D.Double();
            }
            if ((parts = ce.getBranchPoints(parts)).size() == 1) {
                IElement part = parts.iterator().next();
                if (ElementUtils.isHidden(part)) {
                    return new Rectangle2D.Double();
                }
                Shape shape = this.getSelectionShape(part);
                return shape;
            }
            Area area = new Area();
            for (IElement part : parts) {
                if (ElementUtils.isHidden(part)) continue;
                Shape shape = this.getSelectionShape(part);
                Rectangle2D bounds = shape.getBounds2D();
                if (bounds.isEmpty()) {
                    double w = bounds.getWidth();
                    double h = bounds.getHeight();
                    if (w <= 0.0 && h <= 0.0) continue;
                    double exp = 0.1;
                    if (w <= 0.0) {
                        shape = GeometryUtils.expandRectangle((Rectangle2D)bounds, (double)0.0, (double)0.0, (double)0.1, (double)0.1);
                    } else if (h <= 0.0) {
                        shape = GeometryUtils.expandRectangle((Rectangle2D)bounds, (double)0.1, (double)0.1, (double)0.0, (double)0.0);
                    }
                }
                Area a = null;
                a = shape instanceof Area ? (Area)shape : new Area(shape);
                area.add(a);
            }
            parts.clear();
            return area;
        }
    }

    public static class ConnectionChildren
    implements Children,
    ConnectionEntity.ConnectionListener {
        public static final ConnectionChildren INSTANCE = new ConnectionChildren();
        private static final long serialVersionUID = 1L;

        @Override
        public Collection<IElement> getChildren(IElement element, Collection<IElement> result) {
            ConnectionEntity ce = (ConnectionEntity)element.getHint(ElementHints.KEY_CONNECTION_ENTITY);
            if (ce == null) {
                if (result == null) {
                    result = new ArrayList<IElement>(0);
                }
                return result;
            }
            result = ce.getSegments(result);
            result = ce.getBranchPoints(result);
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addChildListener(IElement element, Children.ChildListener listener) {
            ListenerList ll = null;
            IElement iElement = element;
            synchronized (iElement) {
                ll = (ListenerList)element.getHint(CHILD_LISTENERS);
                if (ll == null) {
                    ll = new ListenerList(Children.ChildListener.class);
                    element.setHint(CHILD_LISTENERS, ll);
                    ConnectionEntity entity = (ConnectionEntity)element.getHint(ElementHints.KEY_CONNECTION_ENTITY);
                    entity.setListener(this);
                }
            }
            ll.add((Object)listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeChildListener(IElement element, Children.ChildListener listener) {
            IElement iElement = element;
            synchronized (iElement) {
                ListenerList ll = (ListenerList)element.getHint(CHILD_LISTENERS);
                if (ll == null) {
                    return;
                }
                ll.remove((Object)listener);
                if (ll.isEmpty()) {
                    ConnectionEntity entity = (ConnectionEntity)element.getHint(ElementHints.KEY_CONNECTION_ENTITY);
                    entity.setListener(null);
                }
            }
        }

        @Override
        public void connectionChanged(ConnectionEntity.ConnectionEvent event) {
            this.fireChildrenChanged(event);
        }

        private void fireChildrenChanged(ConnectionEntity.ConnectionEvent event) {
            ListenerList ll = (ListenerList)event.connection.getHint(CHILD_LISTENERS);
            if (ll == null) {
                return;
            }
            Children.ChildEvent ce = new Children.ChildEvent(event.connection, event.removedParts, event.addedParts);
            Children.ChildListener[] childListenerArray = (Children.ChildListener[])ll.getListeners();
            int n = childListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Children.ChildListener cl = childListenerArray[n2];
                cl.elementChildrenChanged(ce);
                ++n2;
            }
        }
    }

    static class ConnectionHandlerImpl
    implements ConnectionHandler {
        public static final ConnectionHandlerImpl INSTANCE = new ConnectionHandlerImpl();
        private static final long serialVersionUID = 3267139233182458330L;

        ConnectionHandlerImpl() {
        }

        @Override
        public Collection<IElement> getBranchPoints(IElement connection, Collection<IElement> result) {
            ConnectionEntity entity = (ConnectionEntity)connection.getHint(ElementHints.KEY_CONNECTION_ENTITY);
            if (entity == null) {
                return Collections.emptySet();
            }
            return entity.getBranchPoints(result);
        }

        @Override
        public Collection<IElement> getChildren(IElement connection, Collection<IElement> result) {
            ConnectionEntity entity = (ConnectionEntity)connection.getHint(ElementHints.KEY_CONNECTION_ENTITY);
            if (entity == null) {
                return Collections.emptySet();
            }
            result = entity.getSegments(result);
            return entity.getBranchPoints(result);
        }

        @Override
        public Collection<IElement> getSegments(IElement connection, Collection<IElement> result) {
            ConnectionEntity entity = (ConnectionEntity)connection.getHint(ElementHints.KEY_CONNECTION_ENTITY);
            if (entity == null) {
                return Collections.emptySet();
            }
            return entity.getSegments(result);
        }

        @Override
        public Collection<Topology.Connection> getTerminalConnections(IElement connection, Collection<Topology.Connection> result) {
            ConnectionEntity entity = (ConnectionEntity)connection.getHint(ElementHints.KEY_CONNECTION_ENTITY);
            if (entity == null) {
                return Collections.emptySet();
            }
            return entity.getTerminalConnections(result);
        }
    }

    public static class ConnectionPick
    implements Pick2 {
        public static final ConnectionPick INSTANCE = new ConnectionPick();
        private static final long serialVersionUID = 1L;

        @Override
        public boolean pickTest(IElement e, Shape s, PickRequest.PickPolicy policy) {
            ConnectionEntity ce = (ConnectionEntity)e.getHint(ElementHints.KEY_CONNECTION_ENTITY);
            if (ce == null) {
                return false;
            }
            Collection<IElement> parts = (Collection<IElement>)perThreadPickList.get();
            parts = ce.getBranchPoints(parts);
            if ((parts = ce.getSegments(parts)).isEmpty()) {
                return false;
            }
            for (IElement part : parts) {
                if (ElementUtils.isHidden(part)) continue;
                for (Pick pick : part.getElementClass().getItemsByClass(Pick.class)) {
                    if (!pick.pickTest(part, s, policy)) continue;
                    return true;
                }
            }
            parts.clear();
            return false;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public int pick(IElement e, Shape s, PickRequest.PickPolicy policy, Collection<IElement> result) {
            IElement part;
            boolean singleEdge;
            int oldResultSize = result.size();
            ConnectionEntity ce = (ConnectionEntity)e.getHint(ElementHints.KEY_CONNECTION_ENTITY);
            if (ce == null) {
                return 0;
            }
            List parts = (List)perThreadPickList.get();
            parts.clear();
            ce.getSegments(parts);
            int edges = parts.size();
            ce.getBranchPoints(parts);
            int branchPoints = parts.size() - edges;
            boolean bl = singleEdge = branchPoints == 0 && edges == 1;
            if (parts.isEmpty()) {
                return 0;
            }
            boolean pickConnection = false;
            block4: for (Outline outline : e.getElementClass().getItemsByClass(Outline.class)) {
                Shape elementShape = outline.getElementShape(e);
                if (elementShape == null) continue;
                switch (policy) {
                    case PICK_CONTAINED_OBJECTS: {
                        if (!org.simantics.g2d.utils.GeometryUtils.contains(s, elementShape)) break;
                        pickConnection = true;
                        break block4;
                    }
                    case PICK_INTERSECTING_OBJECTS: {
                        if (!org.simantics.g2d.utils.GeometryUtils.intersects(s, elementShape)) break;
                        pickConnection = true;
                        break block4;
                    }
                }
            }
            ArrayList<IElement> picks = null;
            int i = 0;
            while (i < edges) {
                part = (IElement)parts.get(i);
                if (!ElementUtils.isHidden(part)) {
                    for (Pick pick : part.getElementClass().getItemsByClass(Pick.class)) {
                        if (!pick.pickTest(part, s, policy)) continue;
                        if (picks == null) {
                            picks = new ArrayList(4);
                        }
                        picks.add(part);
                        break;
                    }
                }
                ++i;
            }
            if (pickConnection) {
                if (picks == null) {
                    picks = new ArrayList<IElement>(4);
                }
                picks.add(e);
            }
            i = edges;
            while (i < parts.size()) {
                part = (IElement)parts.get(i);
                if (!ElementUtils.isHidden(part)) {
                    for (Pick pick : part.getElementClass().getItemsByClass(Pick.class)) {
                        if (!pick.pickTest(part, s, policy)) continue;
                        if (picks == null) {
                            picks = new ArrayList(4);
                        }
                        picks.add(part);
                        break;
                    }
                }
                ++i;
            }
            if (picks != null) {
                if (!singleEdge) {
                    result.addAll(picks);
                } else {
                    result.add(e);
                }
            }
            parts.clear();
            return result.size() - oldResultSize;
        }
    }

    static final class ConnectionSceneGraph
    implements SceneGraph {
        public static final ConnectionSceneGraph INSTANCE = new ConnectionSceneGraph();
        private static final long serialVersionUID = 4232871859964883266L;

        ConnectionSceneGraph() {
        }

        @Override
        public void init(IElement connection, G2DParentNode parent) {
            ConnectionEntity ce = (ConnectionEntity)connection.getHint(ElementHints.KEY_CONNECTION_ENTITY);
            if (ce == null) {
                return;
            }
            List children = (List)perThreadSceneGraphList.get();
            children.clear();
            ce.getSegments(children);
            ce.getBranchPoints(children);
            if (children.isEmpty()) {
                return;
            }
            HashSet<SingleElementNode> tmp = new HashSet<SingleElementNode>();
            int zIndex = 0;
            for (IElement child : children) {
                ElementClass ec = child.getElementClass();
                SingleElementNode holder = (SingleElementNode)child.getHint(ElementHints.KEY_SG_NODE);
                if (holder == null) {
                    holder = (SingleElementNode)parent.addNode(ElementUtils.generateNodeId(child), SingleElementNode.class);
                    child.setHint(ElementHints.KEY_SG_NODE, holder);
                }
                holder.setZIndex(++zIndex);
                Composite composite = (Composite)child.getHint(ElementHints.KEY_COMPOSITE);
                holder.setComposite(composite);
                holder.setVisible(Boolean.valueOf(true));
                for (SceneGraph n : ec.getItemsByClass(SceneGraph.class)) {
                    n.init(child, (G2DParentNode)holder);
                }
                tmp.add(holder);
            }
            for (IG2DNode node : parent.getNodes()) {
                if (!(node instanceof SingleElementNode) || tmp.contains(node)) continue;
                ((SingleElementNode)node).setVisible(Boolean.valueOf(false));
            }
            children.clear();
        }

        @Override
        public void cleanup(IElement e) {
        }
    }

    private static class ThreadLocalList
    extends ThreadLocal<List<IElement>> {
        private ThreadLocalList() {
        }

        @Override
        protected List<IElement> initialValue() {
            return new ArrayList<IElement>();
        }
    }
}

