/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.dnd;

import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.geom.Point2D;
import java.util.Collection;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.dnd.DnDContext;
import org.simantics.g2d.dnd.DragPainter;
import org.simantics.g2d.dnd.IDropTargetParticipant;

public class DropInteractor
extends AbstractCanvasParticipant
implements DropTargetListener {
    private final Component component;
    private DropTarget dropTarget;
    private DnDContext dropCtx;
    int allowedOps;
    IDropTargetParticipant dropAccepter = null;
    private DragPainter currentDragPainter;

    public DropInteractor(Component component) {
        this.component = component;
    }

    @Override
    public void addedToContext(ICanvasContext ctx) {
        super.addedToContext(ctx);
        this.installDropTarget();
    }

    @Override
    public void removedFromContext(ICanvasContext ctx) {
        super.removedFromContext(ctx);
        this.component.setDropTarget(null);
    }

    private int getAllowedOps() {
        int result = 0;
        for (IDropTargetParticipant p : this.getDropParticipants()) {
            result |= p.getAllowedOps();
        }
        return result;
    }

    void installDropTarget() {
        this.allowedOps = this.getAllowedOps();
        this.dropTarget = new DropTarget(this.component, this.allowedOps, this);
    }

    protected Collection<IDropTargetParticipant> getDropParticipants() {
        return this.getContext().getItemsByClass(IDropTargetParticipant.class);
    }

    public Collection<DragPainter> getDragPainters() {
        return this.getContext().getItemsByClass(DragPainter.class);
    }

    @Override
    public void dragEnter(final DropTargetDragEvent dtde) {
        this.dropAccepter = null;
        final Collection<IDropTargetParticipant> participants = this.getDropParticipants();
        if (participants.isEmpty()) {
            dtde.rejectDrag();
            return;
        }
        this.dropCtx = new DnDContext();
        this.syncExec(new Runnable(){

            @Override
            public void run() {
                for (IDropTargetParticipant p : participants) {
                    p.dragEnter(dtde, DropInteractor.this.dropCtx);
                    if (DropInteractor.this.dropCtx.toArray().length <= 0) continue;
                    DropInteractor.this.dropAccepter = p;
                    break;
                }
            }
        });
        if (this.dropCtx.toArray().length == 0) {
            dtde.rejectDrag();
        } else {
            dtde.acceptDrag(dtde.getDropAction());
        }
        Point mouseLocation = dtde.getLocation();
        Point2D.Double mouseControlPos = new Point2D.Double(mouseLocation.getX(), mouseLocation.getY());
        this.currentDragPainter = new DragPainter(this.dropCtx, mouseControlPos);
        this.getContext().add(this.currentDragPainter);
        this.setDirty();
    }

    @Override
    public void dragExit(final DropTargetEvent dte) {
        this.syncExec(new Runnable(){

            @Override
            public void run() {
                if (DropInteractor.this.dropAccepter != null) {
                    DropInteractor.this.dropAccepter.dragExit(dte, DropInteractor.this.dropCtx);
                }
                DropInteractor.this.endDrag();
            }
        });
    }

    @Override
    public void dragOver(final DropTargetDragEvent dtde) {
        final Collection<DragPainter> interactors = this.getDragPainters();
        if (interactors.isEmpty()) {
            dtde.rejectDrag();
            return;
        }
        this.syncExec(new Runnable(){

            @Override
            public void run() {
                Point mouseLocation = dtde.getLocation();
                Point2D.Double mouseControlPos = new Point2D.Double(mouseLocation.getX(), mouseLocation.getY());
                for (DragPainter interactor : interactors) {
                    interactor.setMousePos(mouseControlPos);
                }
                if (DropInteractor.this.dropAccepter != null) {
                    DropInteractor.this.dropAccepter.dragOver(dtde, DropInteractor.this.dropCtx);
                }
            }
        });
    }

    @Override
    public void drop(final DropTargetDropEvent dtde) {
        Collection<DragPainter> interactors = this.getDragPainters();
        if (interactors.isEmpty()) {
            dtde.rejectDrop();
            return;
        }
        Point mouseLocation = dtde.getLocation();
        Point2D.Double mouseControlPos = new Point2D.Double(mouseLocation.getX(), mouseLocation.getY());
        for (DragPainter interactor : interactors) {
            interactor.setMousePos(mouseControlPos, true);
        }
        if (this.currentDragPainter != null) {
            this.getContext().remove(this.currentDragPainter);
            this.currentDragPainter = null;
        }
        this.syncExec(new Runnable(){

            @Override
            public void run() {
                if (DropInteractor.this.dropAccepter != null) {
                    DropInteractor.this.dropAccepter.drop(dtde, DropInteractor.this.dropCtx);
                }
                DropInteractor.this.endDrag();
            }
        });
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void endDrag() {
        Collection dragPainters = this.getContext().getItemsByClass(DragPainter.class);
        if (dragPainters.isEmpty()) {
            return;
        }
        for (DragPainter dp : dragPainters) {
            dp.remove();
        }
        this.dropAccepter = null;
        this.setDirty();
    }
}

