/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.diagram.impl;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.ICanvasParticipant;
import org.simantics.g2d.canvas.IContentContext;
import org.simantics.g2d.canvas.IMouseCaptureContext;
import org.simantics.g2d.canvas.IMouseCursorContext;
import org.simantics.g2d.canvas.impl.MouseCaptureContext;
import org.simantics.g2d.canvas.impl.MouseCursorContext;
import org.simantics.g2d.canvas.impl.PaintableContextImpl;
import org.simantics.g2d.chassis.ITooltipProvider;
import org.simantics.g2d.diagram.DiagramClass;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.impl.Diagram;
import org.simantics.g2d.diagram.participant.DiagramParticipant;
import org.simantics.g2d.diagram.participant.ElementInteractor;
import org.simantics.g2d.diagram.participant.ElementPainter;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.diagram.participant.TerminalPainter;
import org.simantics.g2d.diagram.participant.ZOrderHandler;
import org.simantics.g2d.diagram.participant.pointertool.PointerInteractor;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.multileveldiagram.TransitionFunction;
import org.simantics.g2d.multileveldiagram.ZoomTransitionParticipant;
import org.simantics.g2d.participant.BackgroundPainter;
import org.simantics.g2d.participant.CanvasGrab;
import org.simantics.g2d.participant.GridPainter;
import org.simantics.g2d.participant.HandPainter;
import org.simantics.g2d.participant.KeyToCommand;
import org.simantics.g2d.participant.KeyUtil;
import org.simantics.g2d.participant.MouseUtil;
import org.simantics.g2d.participant.PointerPainter;
import org.simantics.g2d.participant.RulerPainter;
import org.simantics.g2d.participant.SubCanvas;
import org.simantics.g2d.participant.SymbolUtil;
import org.simantics.g2d.participant.TimeParticipant;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.events.Event;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.EventHandlerStack;
import org.simantics.scenegraph.g2d.events.EventQueue;
import org.simantics.scenegraph.g2d.events.IEventHandler;
import org.simantics.scenegraph.g2d.events.IEventHandlerStack;
import org.simantics.scenegraph.g2d.events.IEventQueue;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.events.MouseEventCoalescer;
import org.simantics.scenegraph.g2d.events.command.CommandKeyBinding;
import org.simantics.utils.datastructures.context.Context;
import org.simantics.utils.datastructures.context.IContext;
import org.simantics.utils.datastructures.context.IContextListener;
import org.simantics.utils.datastructures.hints.HintContext;
import org.simantics.utils.datastructures.hints.HintStack;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintStack;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;

public class ElementDiagram
implements IDiagram {
    private final ICanvasContext ctx;
    private final ICanvasContext parentCtx;
    private IDiagram diagram;
    private final SubCanvas subCanvas;
    private Rectangle2D canvasRect = new Rectangle2D.Double(0.0, 0.0, 200.0, 200.0);
    private int canvasPosX = 100;
    private int canvasPosY = 100;

    public ElementDiagram(ICanvasContext parentCtx) {
        ICanvasParticipant elementInteractor;
        this.parentCtx = parentCtx;
        this.ctx = this.createCanvas(parentCtx.getThreadAccess(), parentCtx.getSceneGraph());
        ICanvasParticipant mouseUtil = (ICanvasParticipant)this.ctx.getSingleItem(MouseUtil.class);
        if (mouseUtil != null) {
            this.ctx.remove(mouseUtil);
            this.ctx.add(new ElementDiagramMouseUtil());
        }
        if ((elementInteractor = (ICanvasParticipant)this.ctx.getSingleItem(ElementInteractor.class)) != null) {
            this.ctx.remove(elementInteractor);
            this.ctx.add(new ElementDiagramElementInteractor());
        }
        this.diagram = this.createDiagram();
        this.ctx.getDefaultHintContext().setHint(DiagramHints.KEY_DIAGRAM, (Object)this.diagram);
        this.subCanvas = new SubCanvas(this.ctx, 10000, 2147483547, 10000);
        parentCtx.add(this.subCanvas);
    }

    public void setSize(int x, int y, int width, int height) {
        this.canvasPosX = x;
        this.canvasPosY = y;
        this.canvasRect = new Rectangle2D.Double(0.0, 0.0, width, height);
        this.getCanvas().getCanvasNode().setTransform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, x, y));
    }

    public Rectangle2D getSize() {
        return this.canvasRect;
    }

    public IDiagram createDiagram() {
        IDiagram d = Diagram.spawnNew(DiagramClass.DEFAULT);
        return d;
    }

    public ICanvasContext createCanvas(IThreadWorkQueue thread, G2DSceneGraph sg) {
        return this.createDefaultCanvas(thread, sg);
    }

    public void setDiagram(IDiagram diagram) {
        this.diagram = diagram;
        this.ctx.getDefaultHintContext().setHint(DiagramHints.KEY_DIAGRAM, (Object)diagram);
    }

    public ICanvasContext getCanvas() {
        return this.ctx;
    }

    public ICanvasContext getParentCanvas() {
        return this.parentCtx;
    }

    public SubCanvas getSubCanvas() {
        return this.subCanvas;
    }

    public IDiagram getDiagram() {
        return this.diagram;
    }

    @Override
    public void addElement(IElement element) {
        this.diagram.addElement(element);
    }

    @Override
    public void removeElement(IElement element) {
        this.diagram.removeElement(element);
    }

    @Override
    public void addCompositionListener(IDiagram.CompositionListener listener) {
        this.diagram.addCompositionListener(listener);
    }

    @Override
    public void addCompositionVetoListener(IDiagram.CompositionVetoListener listener) {
        this.diagram.addCompositionVetoListener(listener);
    }

    public void addHintListener(IHintListener listener) {
        this.diagram.addHintListener(listener);
    }

    public void addHintListener(IThreadWorkQueue threadAccess, IHintListener listener) {
        this.diagram.addHintListener(threadAccess, listener);
    }

    public void addKeyHintListener(IThreadWorkQueue threadAccess, IHintContext.Key key, IHintListener listener) {
        this.diagram.addKeyHintListener(threadAccess, key, listener);
    }

    public void addKeyHintListener(IHintContext.Key key, IHintListener listener) {
        this.diagram.addKeyHintListener(key, listener);
    }

    @Override
    public boolean bringToTop(IElement e) {
        return this.diagram.bringToTop(e);
    }

    @Override
    public boolean bringUp(IElement e) {
        return this.diagram.bringUp(e);
    }

    @Override
    public void destroy() {
        this.diagram.destroy();
    }

    @Override
    public void dispose() {
        this.diagram.dispose();
    }

    @Override
    public DiagramClass getDiagramClass() {
        return this.diagram.getDiagramClass();
    }

    @Override
    public boolean containsElement(IElement element) {
        return this.diagram.containsElement(element);
    }

    @Override
    public List<IElement> getElements() {
        return this.diagram.getElements();
    }

    @Override
    public void sort(Comparator<IElement> comparator) {
        this.diagram.sort(comparator);
    }

    @Override
    public List<IElement> getSnapshot() {
        return this.diagram.getSnapshot();
    }

    public boolean containsHint(IHintContext.Key key) {
        return this.diagram.containsHint(key);
    }

    public <E> E getHint(IHintContext.Key key) {
        return (E)this.diagram.getHint(key);
    }

    public Map<IHintContext.Key, Object> getHints() {
        return this.diagram.getHints();
    }

    public <E extends IHintContext.Key> Map<E, Object> getHintsOfClass(Class<E> clazz) {
        return this.diagram.getHintsOfClass(clazz);
    }

    @Override
    public boolean moveTo(IElement e, int position) {
        return this.diagram.moveTo(e, position);
    }

    @Override
    public void removeCompositionListener(IDiagram.CompositionListener listener) {
        this.diagram.removeCompositionListener(listener);
    }

    @Override
    public void removeCompositionVetoListener(IDiagram.CompositionVetoListener listener) {
        this.diagram.removeCompositionVetoListener(listener);
    }

    public <E> E removeHint(IHintContext.Key key) {
        return (E)this.diagram.removeHint(key);
    }

    public void removeHintListener(IHintListener listener) {
        this.diagram.removeHintListener(listener);
    }

    public void removeHintListener(IThreadWorkQueue threadAccess, IHintListener listener) {
        this.diagram.removeHintListener(threadAccess, listener);
    }

    public void removeKeyHintListener(IThreadWorkQueue threadAccess, IHintContext.Key key, IHintListener listener) {
        this.diagram.removeKeyHintListener(threadAccess, key, listener);
    }

    public void removeKeyHintListener(IHintContext.Key key, IHintListener listener) {
        this.diagram.removeKeyHintListener(key, listener);
    }

    @Override
    public boolean sendDown(IElement e) {
        return this.diagram.sendDown(e);
    }

    @Override
    public boolean sendToBottom(IElement e) {
        return this.diagram.sendToBottom(e);
    }

    public void setHint(IHintContext.Key key, Object value) {
        this.diagram.setHint(key, value);
    }

    public void setHints(Map<IHintContext.Key, Object> hints) {
        this.diagram.setHints(hints);
    }

    public ICanvasContext createDefaultCanvas(IThreadWorkQueue thread, G2DSceneGraph sg) {
        ElementDiagramCanvasContext canvasContext = new ElementDiagramCanvasContext(thread, sg);
        IHintContext h = canvasContext.getDefaultHintContext();
        canvasContext.add(new TransformUtil());
        canvasContext.add(new MouseUtil());
        canvasContext.add(new KeyUtil());
        canvasContext.add(new CanvasGrab());
        canvasContext.add(new SymbolUtil());
        canvasContext.add(new TimeParticipant());
        canvasContext.add(new HandPainter());
        h.setHint(PointerPainter.KEY_PAINT_POINTER, (Object)true);
        canvasContext.add(new GridPainter());
        canvasContext.add(new RulerPainter());
        canvasContext.add(new BackgroundPainter());
        h.setHint(Hints.KEY_GRID_COLOR, (Object)new Color(0.9f, 0.9f, 0.9f));
        h.setHint(Hints.KEY_BACKGROUND_COLOR, (Object)Color.LIGHT_GRAY);
        canvasContext.add(new KeyToCommand(CommandKeyBinding.DEFAULT_BINDINGS));
        canvasContext.add(new PointerInteractor());
        canvasContext.add(new ElementInteractor());
        canvasContext.add(new Selection());
        canvasContext.add(new DiagramParticipant());
        canvasContext.add(new ElementPainter());
        canvasContext.add(new TerminalPainter(true, true, false, true));
        canvasContext.add(new ZOrderHandler());
        canvasContext.add(new ZoomTransitionParticipant(TransitionFunction.SIGMOID));
        h.setHint(Hints.KEY_TOOL, (Object)Hints.PANTOOL);
        return canvasContext;
    }

    public MouseEvent createMouseEvent(MouseEvent e) {
        double y;
        MouseEvent.MouseButtonPressedEvent newEvent = null;
        double x = e.controlPosition.getX();
        Point2D.Double newPos = new Point2D.Double(x - (double)this.canvasPosX, (y = e.controlPosition.getY()) - (double)this.canvasPosY);
        if (!this.canvasRect.contains(newPos)) {
            return new MouseEvent.MouseExitEvent(e.context, e.time, e.mouseId, e.buttons, e.stateMask, (Point2D)newPos, e.screenPosition);
        }
        if (e instanceof MouseEvent.MouseButtonPressedEvent) {
            newEvent = new MouseEvent.MouseButtonPressedEvent(e.context, e.time, e.mouseId, e.buttons, e.stateMask, ((MouseEvent.MouseButtonEvent)e).button, (Point2D)newPos, e.screenPosition);
        } else if (e instanceof MouseEvent.MouseButtonReleasedEvent) {
            newEvent = new MouseEvent.MouseButtonReleasedEvent(e.context, e.time, e.mouseId, e.buttons, e.stateMask, ((MouseEvent.MouseButtonEvent)e).button, ((MouseEvent.MouseButtonReleasedEvent)e).holdTime, (Point2D)newPos, e.screenPosition);
        } else if (e instanceof MouseEvent.MouseDoubleClickedEvent) {
            newEvent = new MouseEvent.MouseDoubleClickedEvent(e.context, e.time, e.mouseId, e.buttons, e.stateMask, ((MouseEvent.MouseButtonEvent)e).button, (Point2D)newPos, e.screenPosition);
        } else if (e instanceof MouseEvent.MouseClickEvent) {
            newEvent = new MouseEvent.MouseClickEvent(e.context, e.time, e.mouseId, e.buttons, e.stateMask, ((MouseEvent.MouseButtonEvent)e).button, ((MouseEvent.MouseClickEvent)e).clickCount, (Point2D)newPos, e.screenPosition);
        } else if (e instanceof MouseEvent.MouseDragBegin) {
            newEvent = new MouseEvent.MouseDragBegin(e.context, e.time, e.mouseId, e.buttons, e.stateMask, ((MouseEvent.MouseButtonEvent)e).button, ((MouseEvent.MouseDragBegin)e).startCanvasPos, ((MouseEvent.MouseDragBegin)e).startControlPos, (Point2D)newPos, e.screenPosition);
        } else if (e instanceof MouseEvent.MouseEnterEvent) {
            newEvent = new MouseEvent.MouseEnterEvent(e.context, e.time, e.mouseId, e.buttons, e.stateMask, (Point2D)newPos, e.screenPosition);
        } else if (e instanceof MouseEvent.MouseExitEvent) {
            newEvent = new MouseEvent.MouseExitEvent(e.context, e.time, e.mouseId, e.buttons, e.stateMask, (Point2D)newPos, e.screenPosition);
        } else if (e instanceof MouseEvent.MouseMovedEvent) {
            newEvent = new MouseEvent.MouseMovedEvent(e.context, e.time, e.mouseId, e.buttons, e.stateMask, (Point2D)newPos, e.screenPosition);
        } else if (e instanceof MouseEvent.MouseWheelMovedEvent) {
            newEvent = new MouseEvent.MouseWheelMovedEvent(e.context, e.time, e.mouseId, e.buttons, e.stateMask, (Point2D)newPos, e.screenPosition, ((MouseEvent.MouseWheelMovedEvent)e).scrollType, ((MouseEvent.MouseWheelMovedEvent)e).scrollAmount, ((MouseEvent.MouseWheelMovedEvent)e).wheelRotation);
        } else {
            throw new Error("Unknow event " + e.getClass() + " " + e);
        }
        return newEvent;
    }

    public class ElementDiagramCanvasContext
    extends Context<ICanvasParticipant>
    implements ICanvasContext {
        protected HintStack hintStack;
        protected HintContext bottomHintContext;
        protected IEventHandlerStack eventHandlerStack;
        protected boolean eventHandlingOrdered;
        protected EventQueue eventQueue;
        protected IContentContext paintableCtx;
        protected final IThreadWorkQueue thread;
        protected IMouseCaptureContext mouseCaptureCtx;
        protected IMouseCursorContext mouseCursorCtx;
        protected G2DSceneGraph sg;
        protected G2DParentNode canvasNode;
        protected ITooltipProvider tooltip;
        private final Runnable eventHandling;
        protected final AtomicBoolean locked;

        public ElementDiagramCanvasContext(IThreadWorkQueue thread, G2DSceneGraph sg) {
            super(ICanvasParticipant.class);
            this.hintStack = new HintStack();
            this.bottomHintContext = new HintContext();
            this.eventHandlerStack = null;
            this.eventHandlingOrdered = false;
            this.eventQueue = null;
            this.paintableCtx = new PaintableContextImpl();
            this.mouseCaptureCtx = new MouseCaptureContext();
            this.mouseCursorCtx = new MouseCursorContext();
            this.canvasNode = null;
            this.eventHandling = new Runnable(){

                @Override
                public void run() {
                    ElementDiagramCanvasContext.this.eventHandlingOrdered = false;
                    ElementDiagramCanvasContext.this.eventQueue.handleEvents();
                }
            };
            this.locked = new AtomicBoolean(false);
            if (thread == null) {
                throw new IllegalArgumentException("null");
            }
            this.thread = thread;
            this.eventHandlerStack = new EventHandlerStack(thread);
            this.eventQueue = new EventQueue((IEventHandler)this.eventHandlerStack);
            this.hintStack.addHintContext((IHintContext)this.bottomHintContext, Integer.MIN_VALUE);
            this.sg = sg;
            this.canvasNode = (G2DParentNode)sg.addNode("elementdnavigation", G2DParentNode.class);
            this.canvasNode.setZIndex(1000);
            this.addContextListener(thread, (IContextListener)new IContextListener<ICanvasParticipant>(){

                public void itemAdded(IContext<ICanvasParticipant> sender, ICanvasParticipant item) {
                    item.addedToContext(ElementDiagramCanvasContext.this);
                }

                public void itemRemoved(IContext<ICanvasParticipant> sender, ICanvasParticipant item) {
                    item.removedFromContext(ElementDiagramCanvasContext.this);
                }
            });
            this.eventQueue.addEventCoalesceler((IEventQueue.EventCoalescer)MouseEventCoalescer.INSTANCE);
            this.eventQueue.addQueueListener(new IEventQueue.IEventQueueListener(){

                public void onEventAdded(IEventQueue queue, Event e, int index) {
                    ElementDiagramCanvasContext.this.asyncHandleEvents();
                }

                public void onQueueEmpty(IEventQueue queue) {
                }
            });
        }

        @Override
        public IHintStack getHintStack() {
            this.assertNotDisposed();
            return this.hintStack;
        }

        synchronized void asyncHandleEvents() {
            if (this.eventHandlingOrdered) {
                return;
            }
            this.eventHandlingOrdered = true;
            ThreadUtils.asyncExec((IThreadWorkQueue)this.thread, (Runnable)this.eventHandling);
        }

        synchronized void syncHandleEvents() {
            if (this.eventHandlingOrdered) {
                return;
            }
            this.eventHandlingOrdered = true;
            ThreadUtils.syncExec((IThreadWorkQueue)this.thread, (Runnable)this.eventHandling);
        }

        @Override
        public IEventHandlerStack getEventHandlerStack() {
            this.assertNotDisposed();
            return this.eventHandlerStack;
        }

        @Override
        public IThreadWorkQueue getThreadAccess() {
            return this.thread;
        }

        protected void doDispose() {
            ThreadUtils.syncExec((IThreadWorkQueue)this.getThreadAccess(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    ElementDiagramCanvasContext.this.clear();
                    if (ElementDiagramCanvasContext.this.sg != null) {
                        ElementDiagramCanvasContext.this.sg.removeNodes();
                        ElementDiagramCanvasContext.this.sg = null;
                    }
                }
            });
        }

        @Override
        public IHintContext getDefaultHintContext() {
            return this.bottomHintContext;
        }

        @Override
        public IMouseCursorContext getMouseCursorContext() {
            return this.mouseCursorCtx;
        }

        @Override
        public void setMouseCursorContext(IMouseCursorContext ctx) {
            this.mouseCursorCtx = ctx;
        }

        @Override
        public IMouseCaptureContext getMouseCaptureContext() {
            return this.mouseCaptureCtx;
        }

        @Override
        public void setMouseCaptureContext(IMouseCaptureContext mctx) {
            this.mouseCaptureCtx = mctx;
        }

        @Override
        public IEventQueue getEventQueue() {
            return this.eventQueue;
        }

        @Override
        public IContentContext getContentContext() {
            return this.paintableCtx;
        }

        @Override
        public void setContentContext(IContentContext ctx) {
            this.paintableCtx = ctx;
        }

        @Override
        public G2DSceneGraph getSceneGraph() {
            return this.sg;
        }

        @Override
        public G2DParentNode getCanvasNode() {
            return this.canvasNode;
        }

        @Override
        public void setCanvasNode(G2DParentNode node) {
            throw new RuntimeException("Cannot set canvasNode");
        }

        @Override
        public boolean isLocked() {
            return this.locked.get();
        }

        @Override
        public void setLocked(boolean locked) {
            boolean previous = this.locked.getAndSet(locked);
            if (!locked && previous != locked) {
                this.getContentContext().setDirty();
            }
        }

        @Override
        public ITooltipProvider getTooltipProvider() {
            return this.tooltip;
        }

        @Override
        public void setTooltipProvider(ITooltipProvider tooltipProvider) {
            this.tooltip = tooltipProvider;
        }
    }

    public class ElementDiagramElementInteractor
    extends ElementInteractor {
        @Override
        @EventHandlerReflection.EventHandler(priority=0x7FFFFFFE)
        public boolean handleMouseEvent(MouseEvent me) {
            MouseEvent ne = ElementDiagram.this.createMouseEvent(me);
            if (ne != null) {
                return super.handleMouseEvent(ne);
            }
            return false;
        }
    }

    public class ElementDiagramMouseUtil
    extends MouseUtil {
        @Override
        @EventHandlerReflection.EventHandler(priority=0x7FFFFFFF)
        public boolean handleMouseEvent(MouseEvent e) {
            MouseEvent ne = ElementDiagram.this.createMouseEvent(e);
            if (ne != null) {
                return this.handleMouseEvent2(ne);
            }
            return false;
        }

        public boolean handleMouseEvent2(MouseEvent e) {
            this.assertDependencies();
            if (e instanceof MouseEvent.MouseEnterEvent) {
                Point2D canvasPosition = this.util.controlToCanvas(e.controlPosition, null);
                MouseUtil.MouseInfo mi = new MouseUtil.MouseInfo(e.mouseId, e.controlPosition, canvasPosition, e.buttons);
                this.miceInfo.put(e.mouseId, mi);
            } else if (e instanceof MouseEvent.MouseExitEvent) {
                this.miceInfo.remove(e.mouseId);
            } else if (e instanceof MouseEvent.MouseMovedEvent) {
                Point2D canvasPosition = this.util.controlToCanvas(e.controlPosition, null);
                double deltaDistance = 0.0;
                MouseUtil.MouseInfo mi = (MouseUtil.MouseInfo)this.miceInfo.get(e.mouseId);
                if (mi == null) {
                    mi = new MouseUtil.MouseInfo(e.mouseId, e.controlPosition, canvasPosition, 0);
                    this.miceInfo.put(e.mouseId, mi);
                } else {
                    deltaDistance = e.controlPosition.distance(mi.controlPosition);
                    mi.controlPosition = e.controlPosition;
                    mi.canvasPosition = canvasPosition;
                }
                if (deltaDistance > 0.0) {
                    mi.addDistanceForButtons(deltaDistance);
                }
                for (MouseUtil.ButtonInfo bi : mi.buttonPressInfo.values()) {
                    if (!bi.down || bi.deltaMotion <= this.profile.movementTolerance || bi.drag) continue;
                    bi.drag = true;
                    MouseEvent.MouseDragBegin db = new MouseEvent.MouseDragBegin((Object)this, e.time, e.mouseId, e.buttons, e.stateMask, bi.button, bi.canvasPosition, bi.controlPosition, e.controlPosition, e.screenPosition);
                    this.getContext().getEventQueue().queueFirst((Event)db);
                }
            } else if (e instanceof MouseEvent.MouseButtonPressedEvent) {
                Point2D canvasPosition = this.util.controlToCanvas(e.controlPosition, null);
                MouseEvent.MouseButtonPressedEvent me = (MouseEvent.MouseButtonPressedEvent)e;
                MouseUtil.MouseInfo mi = (MouseUtil.MouseInfo)this.miceInfo.get(e.mouseId);
                if (mi == null) {
                    mi = new MouseUtil.MouseInfo(e.mouseId, e.controlPosition, canvasPosition, e.buttons);
                    this.miceInfo.put(e.mouseId, mi);
                } else {
                    mi.controlPosition = e.controlPosition;
                    mi.canvasPosition = canvasPosition;
                }
                mi.setButtonPressed(me.button, e.stateMask, e.controlPosition, canvasPosition, e.time);
            } else if (e instanceof MouseEvent.MouseButtonReleasedEvent) {
                MouseEvent.MouseButtonReleasedEvent me = (MouseEvent.MouseButtonReleasedEvent)e;
                Point2D canvasPosition = this.util.controlToCanvas(me.controlPosition, null);
                MouseUtil.MouseInfo mi = (MouseUtil.MouseInfo)this.miceInfo.get(me.mouseId);
                if (mi == null) {
                    mi = new MouseUtil.MouseInfo(e.mouseId, me.controlPosition, canvasPosition, 0);
                    this.miceInfo.put(me.mouseId, mi);
                } else {
                    mi.controlPosition = me.controlPosition;
                    mi.canvasPosition = canvasPosition;
                }
                MouseUtil.ButtonInfo bi = mi.releaseButton(me.button, me.time);
                if (bi == null) {
                    return false;
                }
                if (me.holdTime > this.profile.clickHoldTimeTolerance) {
                    return false;
                }
                if (bi.deltaMotion > this.profile.movementTolerance) {
                    return false;
                }
                long timeSinceLastClick = me.time - bi.lastClickEventTime;
                bi.lastClickEventTime = me.time;
                bi.clickCount = timeSinceLastClick > this.profile.consecutiveToleranceTime ? 0 : ++bi.clickCount;
            }
            return false;
        }
    }
}

