/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.diagram.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.simantics.g2d.diagram.DiagramMutator;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.ElementFactory;
import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementClassProviders;
import org.simantics.g2d.element.ElementClasses;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.IElementClassProvider;
import org.simantics.g2d.element.handler.EdgeVisuals;
import org.simantics.g2d.element.handler.impl.StaticObjectAdapter;
import org.simantics.g2d.element.impl.Element;
import org.simantics.g2d.elementclass.FlagClass;
import org.simantics.g2d.elementclass.connection.ConnectionClass;
import org.simantics.utils.datastructures.cache.ProvisionException;

public class DummyDiagramMutator
implements DiagramMutator {
    public static final IElementClassProvider DEFAULT_PROVIDER = ElementClassProviders.mappedProvider(ElementClasses.CONNECTION, ConnectionClass.CLASS.newClassWith(new StaticObjectAdapter(new Object())), ElementClasses.FLAG, FlagClass.FLAGCLASS.newClassWith(new StaticObjectAdapter(new Object())));
    IElementClassProvider classProvider;
    private final Map<IElement, Object> map = new HashMap<IElement, Object>();
    private final IDiagram diagram;
    private final Topology diagramTopology;

    public DummyDiagramMutator(IDiagram diagram) {
        this(diagram, DEFAULT_PROVIDER);
    }

    public DummyDiagramMutator(IDiagram diagram, IElementClassProvider classProvider) {
        this.diagram = diagram;
        this.diagramTopology = diagram.getDiagramClass().getAtMostOneItemOfClass(Topology.class);
        this.classProvider = classProvider;
        this.ensureClassProvision(ElementClasses.CONNECTION);
        this.ensureClassProvision(ElementClasses.FLAG);
    }

    private void ensureClassProvision(Object key) {
        ElementClass ec = this.classProvider.get(key);
        if (ec == null) {
            throw new ProvisionException();
        }
    }

    @Override
    public void synchronizeHintsToBackend(IElement element) {
    }

    @Override
    public void synchronizeElementOrder() {
    }

    @Override
    public void removeElement(IElement element) {
        this.diagram.removeElement(element);
    }

    @Override
    public void register(IElement element, Object object) {
        this.map.put(element, object);
    }

    private IElement spawn(ElementClass clazz) {
        ElementFactory ef = this.diagram.getDiagramClass().getAtMostOneItemOfClass(ElementFactory.class);
        if (ef != null) {
            return ef.spawnNew(clazz);
        }
        return Element.spawnNew(clazz);
    }

    @Override
    public IElement newElement(ElementClass clazz) {
        IElement element = this.spawn(clazz);
        element.setHint(ElementHints.KEY_OBJECT, new Object());
        return element;
    }

    @Override
    public void modifyTransform(IElement element) {
    }

    @Override
    public void modifyProperty(IElement element, Object backend, Object value) {
    }

    @Override
    public Collection<Topology.Connection> getConnections(IElement node, Topology.Terminal terminal) {
        ArrayList<Topology.Connection> result = new ArrayList<Topology.Connection>();
        this.diagramTopology.getConnections(node, terminal, result);
        return result;
    }

    @Override
    public Topology.Connection getConnection(IElement edge, EdgeVisuals.EdgeEnd end) {
        return this.diagramTopology.getConnection(edge, end);
    }

    @Override
    public IElement copyElement(IElement source) {
        return null;
    }

    @Override
    public void offer(IElement context, Object modification) {
    }

    @Override
    public void commit() {
        this.map.clear();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public <T> T backendObject(IElement element) {
        return (T)this.map.get(element);
    }
}

