/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.diagram.handler;

import java.util.Collection;
import org.simantics.g2d.diagram.handler.DiagramHandler;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.EdgeVisuals;

public interface Topology
extends DiagramHandler {
    public Connection getConnection(IElement var1, EdgeVisuals.EdgeEnd var2);

    public void getConnections(IElement var1, Terminal var2, Collection<Connection> var3);

    public void connect(IElement var1, EdgeVisuals.EdgeEnd var2, IElement var3, Terminal var4);

    public void disconnect(IElement var1, EdgeVisuals.EdgeEnd var2, IElement var3, Terminal var4);

    public static class Connection {
        public final Terminal terminal;
        public final IElement edge;
        public final IElement node;
        public final EdgeVisuals.EdgeEnd end;

        public Connection(IElement edge, EdgeVisuals.EdgeEnd end, IElement node, Terminal terminal) {
            assert (edge != null);
            assert (end != null);
            assert (terminal == null && node == null || node != null && terminal != null);
            this.edge = edge;
            this.end = end;
            this.node = node;
            this.terminal = terminal;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Connection)) {
                return false;
            }
            Connection other = (Connection)obj;
            return other.terminal == this.terminal && other.edge == this.edge && other.node == this.node && other.end == this.end;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.edge.hashCode();
            result = 31 * result + this.end.hashCode();
            result = 31 * result + (this.node == null ? 0 : this.node.hashCode());
            result = 31 * result + (this.terminal == null ? 0 : this.terminal.hashCode());
            return result;
        }

        public String toString() {
            return "Topology.Connection[edge=" + this.edge + ", node=" + this.node + ", terminal=" + this.terminal + ", end=" + (Object)((Object)this.end) + "]";
        }
    }

    public static interface Terminal {
    }
}

