/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.chassis;

import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.ImageCapabilities;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferStrategy;
import java.lang.reflect.Method;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.IContentContext;
import org.simantics.g2d.canvas.IMouseCursorContext;
import org.simantics.g2d.canvas.IMouseCursorListener;
import org.simantics.g2d.chassis.AbstractChassis;
import org.simantics.g2d.chassis.ICanvasChassis;
import org.simantics.g2d.chassis.IChassisListener;
import org.simantics.g2d.dnd.DragInteractor;
import org.simantics.g2d.dnd.DropInteractor;
import org.simantics.g2d.participant.RenderingQualityInteractor;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.scenegraph.g2d.G2DRenderingHints;
import org.simantics.scenegraph.g2d.events.adapter.AWTFocusAdapter;
import org.simantics.scenegraph.g2d.events.adapter.AWTKeyEventAdapter;
import org.simantics.scenegraph.g2d.events.adapter.AWTMouseEventAdapter;
import org.simantics.utils.threads.AWTThread;
import org.simantics.utils.threads.Executable;
import org.simantics.utils.threads.SyncListenerList;
import org.simantics.utils.threads.ThreadUtils;

public class FullscreenChassis
extends AbstractChassis
implements ICanvasChassis {
    protected Frame frame;
    protected Canvas canvas;
    protected BufferStrategy bufferStrategy;
    protected Graphics2D g2d;
    protected TransformUtil viewboxInteractor;
    protected AWTMouseEventAdapter mouseAdapter;
    protected AWTFocusAdapter focusAdapter;
    protected AWTKeyEventAdapter keyAdapter;
    transient boolean dirty = false;
    KeyListener escapeListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                FullscreenChassis.this.frame.dispose();
            }
        }
    };
    private static final Method CLOSED_METHOD = SyncListenerList.getMethod(IChassisListener.class, (String)"chassisClosed");

    public FullscreenChassis(String windowTitle, boolean ruler) {
        this(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice(), windowTitle, ruler);
    }

    public void redraw() {
        this.canvas.repaint();
    }

    public FullscreenChassis(GraphicsDevice monitor, String windowTitle, boolean ruler) {
        DisplayMode dm = monitor.getDisplayMode();
        this.frame = new Frame(windowTitle);
        this.frame.setSize(dm.getWidth(), dm.getHeight());
        this.frame.setUndecorated(true);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FullscreenChassis.this.frame.dispose();
            }

            @Override
            public void windowClosed(WindowEvent e) {
                if (FullscreenChassis.this.g2d != null) {
                    FullscreenChassis.this.g2d.dispose();
                    FullscreenChassis.this.g2d = null;
                }
                FullscreenChassis.this.fireChassisClosed();
            }
        });
        this.canvas = new Canvas(){
            private static final long serialVersionUID = -3520733232931837755L;

            @Override
            public void paint(Graphics g) {
                if (FullscreenChassis.this.bufferStrategy == null) {
                    BufferCapabilities caps = new BufferCapabilities(new ImageCapabilities(true), new ImageCapabilities(true), BufferCapabilities.FlipContents.COPIED);
                    try {
                        FullscreenChassis.this.canvas.createBufferStrategy(2, caps);
                    }
                    catch (AWTException e) {
                        FullscreenChassis.this.canvas.createBufferStrategy(2);
                    }
                    FullscreenChassis.this.bufferStrategy = FullscreenChassis.this.canvas.getBufferStrategy();
                }
                if (FullscreenChassis.this.g2d != null && FullscreenChassis.this.bufferStrategy.contentsLost()) {
                    FullscreenChassis.this.g2d.dispose();
                    FullscreenChassis.this.g2d = null;
                }
                if (FullscreenChassis.this.g2d == null) {
                    FullscreenChassis.this.g2d = (Graphics2D)FullscreenChassis.this.bufferStrategy.getDrawGraphics();
                }
                FullscreenChassis.this.paintCanvas(FullscreenChassis.this.g2d);
                FullscreenChassis.this.bufferStrategy.show();
            }

            @Override
            public void update(Graphics g) {
                this.paint(g);
            }
        };
        this.canvas.addKeyListener(this.escapeListener);
        this.frame.addKeyListener(this.escapeListener);
        this.frame.add(this.canvas);
        this.frame.invalidate();
        Rectangle awtBounds = monitor.getDefaultConfiguration().getBounds();
        this.frame.setBounds(awtBounds);
        this.frame.setAlwaysOnTop(true);
        this.frame.setVisible(true);
    }

    @Override
    public void setCanvasContext(ICanvasContext canvasContext) {
        super.setCanvasContext(canvasContext);
        RenderingQualityInteractor rq = new RenderingQualityInteractor();
        canvasContext.add(rq);
        IMouseCursorContext mctx = canvasContext.getMouseCursorContext();
        mctx.addCursorListener(new IMouseCursorListener(){

            @Override
            public void onCursorSet(IMouseCursorContext sender, int mouseId, Cursor cursor) {
                if (mouseId != 0) {
                    return;
                }
                FullscreenChassis.this.canvas.setCursor(cursor);
            }
        }, AWTThread.getThreadAccess());
        assert (canvasContext.getAtMostOneItemOfClass(DropInteractor.class) == null);
        canvasContext.add(new DropInteractor(this.canvas));
        assert (canvasContext.getAtMostOneItemOfClass(DragInteractor.class) == null);
        canvasContext.add(new DragInteractor(this.canvas));
        this.mouseAdapter = new AWTMouseEventAdapter((Object)canvasContext, canvasContext.getEventQueue());
        this.keyAdapter = new AWTKeyEventAdapter((Object)canvasContext, canvasContext.getEventQueue());
        this.focusAdapter = new AWTFocusAdapter((Object)canvasContext, canvasContext.getEventQueue());
        this.canvas.addMouseListener((MouseListener)this.mouseAdapter);
        this.canvas.addMouseMotionListener((MouseMotionListener)this.mouseAdapter);
        this.canvas.addMouseWheelListener((MouseWheelListener)this.mouseAdapter);
        this.canvas.addKeyListener((KeyListener)this.keyAdapter);
        this.canvas.addFocusListener((FocusListener)this.focusAdapter);
        canvasContext.getContentContext().addPaintableContextListener(new IContentContext.IContentListener(){

            @Override
            public void onDirty(IContentContext sender) {
                if (FullscreenChassis.this.dirty) {
                    return;
                }
                FullscreenChassis.this.dirty = true;
                FullscreenChassis.this.redraw();
            }
        });
        this.redraw();
    }

    public void paintCanvas(Graphics2D g) {
        if (this.canvasContext == null) {
            return;
        }
        if (this.canvasContext.isLocked()) {
            return;
        }
        this.dirty = false;
        Rectangle2D.Double bounds = new Rectangle2D.Double(0.0, 0.0, this.frame.getSize().width, this.frame.getSize().height);
        g.setRenderingHint(G2DRenderingHints.KEY_CONTROL_BOUNDS, bounds);
        this.canvasContext.getSceneGraph().render(g);
    }

    protected void fireChassisClosed() {
        Executable[] e = this.listeners.getExecutables(CLOSED_METHOD, new Object[]{this});
        ThreadUtils.multiSyncExec((Executable[])e);
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        return this.frame.getGraphicsConfiguration();
    }

    public Component getAwtComponent() {
        return this.canvas;
    }

    public Frame getFrame() {
        return this.frame;
    }
}

