/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.canvas.impl;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;

public class HintReflection {
    private static final HintListenerDefinition[] EMPTY = new HintListenerDefinition[0];

    public static HintListenerDefinition[] getDependencies(Object obj) {
        HashMap<IHintContext.Key, HintListenerDefinition> result = new HashMap<IHintContext.Key, HintListenerDefinition>();
        Class<?> clazz = obj.getClass();
        HintReflection._add(obj, clazz, result);
        return result.values().toArray(EMPTY);
    }

    private static void _add(Object obj, Class<?> clazz, Map<IHintContext.Key, HintListenerDefinition> result) {
        try {
            Method[] methodArray = clazz.getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                HintListener anno = m.getAnnotation(HintListener.class);
                if (anno != null) {
                    Class<?> keyContainerClass = anno.Class();
                    assert (keyContainerClass != null);
                    String fieldName = anno.Field();
                    assert (fieldName != null);
                    Field field = keyContainerClass.getField(fieldName);
                    assert (field != null);
                    field.setAccessible(true);
                    Object value = field.get(field != null);
                    assert (value != null);
                    assert (value instanceof IHintContext.Key);
                    IHintContext.Key key = (IHintContext.Key)value;
                    Class<?> returnType = m.getReturnType();
                    assert (returnType == Void.TYPE);
                    Class<?>[] params = m.getParameterTypes();
                    assert (params.length == 4 || params.length == 3);
                    assert (params[0].equals(IHintObservable.class));
                    assert (params[1].equals(IHintContext.Key.class));
                    assert (params[2].equals(Object.class));
                    if (params.length == 4) assert (params[3].equals(Object.class));
                    HintListenerDefinition def = result.get(key);
                    if (def == null) {
                        def = new HintListenerDefinition(key, obj);
                        result.put(key, def);
                    }
                    m.setAccessible(true);
                    if (params.length == 4) {
                        def.changedHandlerMethod = m;
                    } else {
                        def.removedHandlerMethod = m;
                    }
                }
                ++n2;
            }
        }
        catch (SecurityException e) {
            throw new Error(e);
        }
        catch (NoSuchFieldException e) {
            throw new Error(e);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            HintReflection._add(obj, superClass, result);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface HintListener {
        public Class<?> Class();

        public String Field();
    }

    public static final class HintListenerDefinition
    implements IHintListener {
        public final IHintContext.Key key;
        public final Object object;
        public Method changedHandlerMethod;
        public Method removedHandlerMethod;

        public HintListenerDefinition(IHintContext.Key key, Object object) {
            this.key = key;
            this.object = object;
        }

        public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
            if (this.changedHandlerMethod == null) {
                return;
            }
            try {
                this.changedHandlerMethod.invoke(this.object, sender, key, oldValue, newValue);
            }
            catch (IllegalArgumentException e) {
                throw new Error(e);
            }
            catch (IllegalAccessException e) {
                throw new Error(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        public void hintRemoved(IHintObservable sender, IHintContext.Key key, Object oldValue) {
            if (this.removedHandlerMethod == null) {
                return;
            }
            try {
                this.removedHandlerMethod.invoke(this.object, sender, key, oldValue);
            }
            catch (IllegalArgumentException e) {
                throw new Error(e);
            }
            catch (IllegalAccessException e) {
                throw new Error(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        }
    }
}

