/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.ui.handler;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.Queries;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleActiveModel;
import org.simantics.db.layer0.util.SessionGarbageCollection;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.issues.common.BatchIssueSource;
import org.simantics.issues.common.SelectedModelBatchIssueSources;
import org.simantics.issues.preferences.IssuePreferenceUtil;
import org.simantics.modeling.utils.BatchValidations;
import org.simantics.utils.ui.ExceptionUtils;

public class RunActiveValidations
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Runnable postValidation = null;
        this.run(postValidation);
        return null;
    }

    public void run(Runnable postValidation) {
        final Session session = Simantics.getSession();
        final ArrayList<BatchIssueSource> validations = new ArrayList<BatchIssueSource>();
        final ArrayList<Resource> contexts = new ArrayList<Resource>();
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        Resource model = (Resource)session.sync((ReadInterface)new PossibleActiveModel(Simantics.getProjectResource()));
                        if (model == null) {
                            return;
                        }
                        try {
                            Collection activeSources = (Collection)session.syncRequest((Read)new SelectedModelBatchIssueSources(model));
                            for (Resource source : activeSources) {
                                BatchIssueSource bis = (BatchIssueSource)session.syncRequest(Queries.adapt((Resource)source, BatchIssueSource.class, (boolean)true));
                                if (bis == null) continue;
                                validations.add(bis);
                            }
                            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Find Composites to Check", (int)100);
                            contexts.addAll(BatchValidations.fillConfig((IProgressMonitor)progress.newChild(100, 0), Collections.singletonList(model)));
                        }
                        catch (DatabaseException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            ExceptionUtils.logAndShowError((Throwable)e.getTargetException());
            return;
        }
        catch (InterruptedException e) {
            return;
        }
        if (!validations.isEmpty() && !contexts.isEmpty()) {
            RunActiveValidations.run(postValidation, validations, contexts);
        }
    }

    public static void run(Runnable postValidation, final Collection<BatchIssueSource> validations, final Collection<Resource> contexts) {
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Validate Model", (int)100);
                            int maxWrittenIssues = IssuePreferenceUtil.getPreferences().maxBatchIssuesToWrite;
                            int writtenIssues = 0;
                            for (BatchIssueSource source : validations) {
                                Map results = BatchValidations.validate((IProgressMonitor)progress.newChild(90, 0), (BatchIssueSource)source, (Collection)contexts);
                                int wroteIssues = BatchValidations.store((IProgressMonitor)progress.newChild(10, 0), (Resource)source.getResource(), (Map)results, (int)Math.max(0, maxWrittenIssues - writtenIssues));
                                writtenIssues += wroteIssues;
                                SessionGarbageCollection.gc(null, (Session)Simantics.getSession(), (boolean)true, null);
                            }
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
            if (postValidation != null) {
                postValidation.run();
            }
        }
        catch (InvocationTargetException e) {
            ExceptionUtils.logAndShowError((Throwable)e.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

