/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.ui.handler;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.issues.common.AllActiveIssues;
import org.simantics.issues.ontology.IssueResource;

public class PurgeResolvedIssues
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            PurgeResolvedIssues.this.purgeResolvedIssues(monitor);
                        }
                        catch (DatabaseException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
        catch (InterruptedException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
        return null;
    }

    private void purgeResolvedIssues(IProgressMonitor monitor) throws DatabaseException {
        Session session = Simantics.getSession();
        final Resource project = Simantics.getProjectResource();
        if (project == null) {
            return;
        }
        final SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)"Purging resolved issues...", (int)100);
        session.syncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
                HashSet<Resource> toBeRemoved = new HashSet<Resource>();
                for (Resource activeIssue : (Set)graph.syncRequest((Read)new AllActiveIssues(project))) {
                    if (!graph.hasStatement(activeIssue, ISSUE.Resolved)) continue;
                    toBeRemoved.add(activeIssue);
                }
                mon.setTaskName("Purging " + toBeRemoved.size() + " resolved issues...");
                mon.setWorkRemaining(toBeRemoved.size());
                for (Resource remove : toBeRemoved) {
                    RemoverUtil.remove((WriteGraph)graph, (Resource)remove);
                    mon.worked(1);
                }
            }
        });
    }
}

