/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.ui.handler;

import java.io.Closeable;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.osgi.service.prefs.BackingStoreException;
import org.simantics.Simantics;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.issues.common.AllVisibleIssues;
import org.simantics.operation.Layer0X;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.utils.DataContainer;
import org.simantics.utils.FileUtils;
import org.simantics.utils.strings.StringUtils;
import org.simantics.utils.ui.ExceptionUtils;

public class ExportIssuesAsCsv
extends AbstractHandler {
    private static final String PROP_LAST_VALIDATION_REPORT_PATH = "validation.report.path";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        try {
            String fileName = this.generateFileName();
            this.validate(window, fileName);
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
        return null;
    }

    private String generateFileName() throws DatabaseException {
        String generatedName = (String)Simantics.getSession().syncRequest((Read)new Read<String>(){

            public String perform(ReadGraph graph) throws DatabaseException {
                Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
                SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
                Iterator iterator = ((Collection)graph.syncRequest((Read)new ObjectsWithType(Simantics.getProjectResource(), L0X.Activates, SIMU.Model))).iterator();
                if (iterator.hasNext()) {
                    Resource model = (Resource)iterator.next();
                    return String.valueOf(NameUtils.getSafeName((ReadGraph)graph, (Resource)model)) + ".txt";
                }
                return "issues.txt";
            }
        });
        if (!FileUtils.isValidFileName((String)generatedName)) {
            generatedName = (String)Bindings.STR_VARIANT.createUnchecked((Binding)Bindings.STRING, (Object)generatedName);
        }
        return generatedName;
    }

    public void validate(IWorkbenchWindow window, String fileName) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.simantics.issues.ui");
        String lastReportPath = prefs.get(PROP_LAST_VALIDATION_REPORT_PATH, null);
        Shell parentShell = null;
        if (window != null) {
            parentShell = window.getShell();
        }
        final DataContainer externalOutput = new DataContainer();
        FileDialog fd = new FileDialog(parentShell, 8192);
        fd.setText("Select Validation Output");
        fd.setFilterExtensions(new String[]{"*.txt", "*.*"});
        fd.setFilterNames(new String[]{"Comma-Separated Values (*.txt)", "All Files (*.*)"});
        if (lastReportPath != null) {
            fd.setFilterPath(lastReportPath);
        }
        fd.setFileName(fileName);
        final String path = fd.open();
        if (path != null) {
            prefs.put(PROP_LAST_VALIDATION_REPORT_PATH, path);
            try {
                prefs.flush();
            }
            catch (BackingStoreException e) {
                ExceptionUtils.logError((Throwable)e);
            }
        } else {
            return;
        }
        try {
            window.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            if (externalOutput.get() == null) {
                                externalOutput.set((Object)new PrintStream(new File(path)));
                            }
                            final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Export issues", (int)-1);
                            Simantics.getSession().syncRequest((Read)new ReadRequest(){

                                public void run(ReadGraph graph) throws DatabaseException {
                                    PrintStream out = (PrintStream)externalOutput.get();
                                    Collection activeIssues = (Collection)graph.syncRequest((Read)new AllVisibleIssues(Simantics.getProjectResource()));
                                    out.println("# Exported issues (" + activeIssues.size() + ")");
                                    for (Variable issue : activeIssues) {
                                        String description = StringUtils.safeString((String)((String)issue.getPossiblePropertyValue(graph, "HasDescription")));
                                        String severity = StringUtils.safeString((String)((String)issue.getPossiblePropertyValue(graph, "severity")));
                                        String resource = StringUtils.safeString((String)((String)issue.getPossiblePropertyValue(graph, "resource")));
                                        String path = StringUtils.safeString((String)((String)issue.getPossiblePropertyValue(graph, "path")));
                                        out.println(String.valueOf(description) + ";" + severity + ";" + resource + ";" + path);
                                        progress.worked(1);
                                    }
                                }
                            });
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                        if (externalOutput.get() != System.out) {
                            FileUtils.uncheckedClose((Closeable)((Closeable)externalOutput.get()));
                        }
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            ExceptionUtils.logAndShowError((Throwable)e.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

