/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.ui.contribution;

import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.layer0.adapter.DropActionFactory;
import org.simantics.db.request.Write;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.modeling.PropertyVariables;
import org.simantics.utils.datastructures.Callback;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ISelectionUtils;

public class IssueContextDropAction
implements DropActionFactory {
    public Runnable create(ReadGraph g, Object target, Object source) throws DatabaseException {
        List ctx;
        Resource issue = (Resource)ISelectionUtils.getSinglePossibleKey((Object)target, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        if (issue == null) {
            return null;
        }
        List vars = ISelectionUtils.getPossibleKeys((Object)source, (IHintContext.Key)SelectionHints.KEY_MAIN, PropertyVariables.class);
        if (vars.isEmpty() && !(ctx = ISelectionUtils.getPossibleKeys((Object)source, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class)).isEmpty()) {
            this.addToIssueContext(g.getSession(), issue, ctx);
        }
        return null;
    }

    private void addToIssueContext(Session session, final Resource issue, final List<Resource> contexts) {
        session.asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
                for (Resource ctx : contexts) {
                    graph.claim(issue, ISSUE.Issue_HasContext, ISSUE.Issue_HasContext, ctx);
                }
            }
        }, (Callback)new Callback<DatabaseException>(){

            public void run(DatabaseException e) {
                if (e != null) {
                    ErrorLogger.defaultLogError((Throwable)e);
                }
            }
        });
    }
}

