/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.ui;

import java.util.Collections;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.browsing.ui.model.images.ImageRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.silk.SilkResources;

public class IssueImageRule
implements ImageRule {
    private final String DESCRIPTION = "single";

    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Variable.class);
    }

    public Map<String, ImageDescriptor> getImage(ReadGraph graph, Object content) throws DatabaseException {
        boolean resolved;
        Variable issue = (Variable)content;
        IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
        SilkResources SILK = SilkResources.getInstance((ReadGraph)graph);
        String severity = (String)issue.getPropertyValue(graph, "severity");
        Resource issueResource = issue.getPossibleRepresents(graph);
        boolean bl = resolved = issueResource != null ? graph.hasStatement(issueResource, ISSUE.Resolved) : false;
        if (resolved) {
            return Collections.singletonMap("single", (ImageDescriptor)graph.adapt(SILK.tick, ImageDescriptor.class));
        }
        if ("Fatal".equals(severity)) {
            return Collections.singletonMap("single", (ImageDescriptor)graph.adapt(SILK.bomb, ImageDescriptor.class));
        }
        if ("Error".equals(severity)) {
            return Collections.singletonMap("single", (ImageDescriptor)graph.adapt(SILK.exclamation, ImageDescriptor.class));
        }
        if ("Warning".equals(severity)) {
            return Collections.singletonMap("single", (ImageDescriptor)graph.adapt(SILK.error, ImageDescriptor.class));
        }
        if ("Info".equals(severity)) {
            return Collections.singletonMap("single", (ImageDescriptor)graph.adapt(SILK.information, ImageDescriptor.class));
        }
        if ("Note".equals(severity)) {
            return Collections.singletonMap("single", (ImageDescriptor)graph.adapt(SILK.note, ImageDescriptor.class));
        }
        return Collections.singletonMap("single", (ImageDescriptor)graph.adapt(SILK.help, ImageDescriptor.class));
    }
}

