/*
 * Decompiled with CFR 0.152.
 */
package xtc.tree;

import java.util.ArrayList;
import java.util.Collection;
import xtc.tree.Annotation;
import xtc.tree.Node;
import xtc.util.Pair;

public abstract class Formatting
extends Annotation {
    Formatting() {
    }

    Formatting(Node node) {
        this.node = node;
    }

    @Override
    public boolean hasTraversal() {
        return true;
    }

    public static Formatting before1(Object before, Node node) {
        return new Before1(before, node);
    }

    public static Formatting after1(Node node, Object after) {
        return new After1(node, after);
    }

    public static Formatting round1(Object before, Node node, Object after) {
        return new Round1(before, node, after);
    }

    public static Formatting variable() {
        return new RoundN();
    }

    static class After1
    extends Formatting {
        Object a1;

        After1(Node node, Object a1) {
            super(node);
            this.a1 = a1;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public Object get(int index) {
            switch (index) {
                case 0: {
                    return this.node;
                }
                case 1: {
                    return this.a1;
                }
            }
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: 2");
        }

        @Override
        public Object set(int index, Object value) {
            switch (index) {
                case 0: {
                    Node old = this.node;
                    this.node = (Node)value;
                    return old;
                }
                case 1: {
                    Object old = this.a1;
                    this.a1 = value;
                    return old;
                }
            }
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: 2");
        }
    }

    static class Before1
    extends Formatting {
        Object b1;

        Before1(Object b1, Node node) {
            super(node);
            this.b1 = b1;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public Object get(int index) {
            switch (index) {
                case 0: {
                    return this.b1;
                }
                case 1: {
                    return this.node;
                }
            }
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: 2");
        }

        @Override
        public Object set(int index, Object value) {
            switch (index) {
                case 0: {
                    Object old = this.b1;
                    this.b1 = value;
                    return old;
                }
                case 1: {
                    Node old = this.node;
                    this.node = (Node)value;
                    return old;
                }
            }
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: 2");
        }
    }

    static class Round1
    extends Formatting {
        Object b1;
        Object a1;

        Round1(Object b1, Node node, Object a1) {
            super(node);
            this.b1 = b1;
            this.a1 = a1;
        }

        @Override
        public int size() {
            return 3;
        }

        @Override
        public Object get(int index) {
            switch (index) {
                case 0: {
                    return this.b1;
                }
                case 1: {
                    return this.node;
                }
                case 2: {
                    return this.a1;
                }
            }
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: 3");
        }

        @Override
        public Object set(int index, Object value) {
            switch (index) {
                case 0: {
                    Object old = this.b1;
                    this.b1 = value;
                    return old;
                }
                case 1: {
                    Node old = this.node;
                    this.node = (Node)value;
                    return old;
                }
                case 2: {
                    Object old = this.a1;
                    this.a1 = value;
                    return old;
                }
            }
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: 3");
        }
    }

    static class RoundN
    extends Formatting {
        private boolean hasNode = false;
        private ArrayList<Object> before = new ArrayList();
        private ArrayList<Object> after = new ArrayList();

        @Override
        public boolean hasVariable() {
            return true;
        }

        @Override
        public void setNode(Node node) {
            this.node = node;
            this.hasNode = true;
        }

        @Override
        public int size() {
            return this.hasNode ? this.before.size() + 1 + this.after.size() : this.before.size();
        }

        @Override
        public Object get(int index) {
            if (!this.hasNode) {
                return this.before.get(index);
            }
            int size1 = this.before.size();
            int size2 = this.after.size();
            int total = size1 + 1 + size2;
            if (index >= 0) {
                if (index < size1) {
                    return this.before.get(index);
                }
                if (index == size1) {
                    return this.node;
                }
                if (index < total) {
                    return this.after.get(index - size1 - 1);
                }
            }
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + total);
        }

        @Override
        public Object set(int index, Object value) {
            if (!this.hasNode) {
                return this.before.set(index, value);
            }
            int size1 = this.before.size();
            int size2 = this.after.size();
            int total = size1 + 1 + size2;
            if (index >= 0) {
                if (index < size1) {
                    return this.before.set(index, value);
                }
                if (index == size1) {
                    Node old = this.node;
                    this.node = (Node)value;
                    return old;
                }
                if (index < total) {
                    return this.after.set(index - size1 - 1, value);
                }
            }
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + total);
        }

        @Override
        public Node add(Object o) {
            if (!this.hasNode) {
                this.before.add(o);
            } else {
                this.after.add(o);
            }
            return this;
        }

        @Override
        public Node addNode(Node node) {
            if (this.hasNode) {
                throw new IllegalStateException("Already has annotated node");
            }
            this.node = node;
            this.hasNode = true;
            return this;
        }

        @Override
        public Node add(int index, Object o) {
            if (!this.hasNode) {
                this.before.add(index, o);
                return this;
            }
            int size1 = this.before.size();
            int size2 = this.after.size();
            int total = size1 + 1 + size2;
            if (index >= 0) {
                if (index < size1) {
                    this.before.add(index, o);
                    return this;
                }
                if (index == size1) {
                    throw new IllegalArgumentException("Can't add to annotated node");
                }
                if (index < total) {
                    this.after.add(index - size1 - 1, o);
                    return this;
                }
            }
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + total);
        }

        @Override
        public Node addAll(Pair<?> p) {
            if (!this.hasNode) {
                p.addTo(this.before);
            } else {
                p.addTo(this.after);
            }
            return this;
        }

        @Override
        public Node addAll(Collection<?> c) {
            if (!this.hasNode) {
                this.before.addAll(c);
            } else {
                this.after.addAll(c);
            }
            return this;
        }

        @Override
        public Object remove(int index) {
            if (!this.hasNode) {
                return this.before.remove(index);
            }
            int size1 = this.before.size();
            int size2 = this.after.size();
            int total = size1 + 1 + size2;
            if (index >= 0) {
                if (index < size1) {
                    return this.before.remove(index);
                }
                if (size1 == index) {
                    throw new IllegalArgumentException("Can't remove annotated node");
                }
                if (index < total) {
                    return this.after.remove(index - size1 - 1);
                }
            }
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + total);
        }
    }
}

