/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart.chart.ge;

import java.util.Collections;
import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.PossibleObjectWithType;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.DropActionFactory;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.JFreeChartResource;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.ui.AdaptionUtils;

public class SeriesDropAction
implements DropActionFactory {
    public Runnable create(ReadGraph g, Object target, Object source) throws DatabaseException {
        Resource t = (Resource)AdaptionUtils.adaptToSingle((Object)target, Resource.class);
        Resource s = (Resource)AdaptionUtils.adaptToSingle((Object)source, Resource.class);
        if (t == null || s == null) {
            return null;
        }
        JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)g);
        if (!g.isInstanceOf(s, jfree.Series)) {
            return null;
        }
        if (!g.isInstanceOf(t, jfree.Series) && !g.isInstanceOf(t, jfree.Axis)) {
            return null;
        }
        return this.getRunnable(t, s);
    }

    private Runnable getRunnable(final Resource t, final Resource s) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SimanticsUI.getSession().asyncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        Resource dataset;
                        if (t == null || s == null) {
                            return;
                        }
                        JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
                        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                        Resource target = t;
                        Resource source = s;
                        Resource droppedOnSeries = null;
                        if (graph.isInstanceOf(target, jfree.Series)) {
                            droppedOnSeries = target;
                            dataset = graph.getPossibleObject(target, l0.PartOf);
                            if (dataset != null) {
                                target = dataset;
                            }
                        }
                        if (graph.isInstanceOf(target, jfree.Axis) && (dataset = (Resource)graph.syncRequest((Read)new PossibleObjectWithType(target, jfree.Dataset_mapToRangeAxis_Inverse, jfree.Dataset))) != null) {
                            target = dataset;
                        }
                        if (graph.isInstanceOf(target, jfree.Dataset)) {
                            Resource sourceSeriesList;
                            Resource sourceDataset = graph.getPossibleObject(source, l0.PartOf);
                            if (sourceDataset != null && !sourceDataset.equals(target) && (sourceSeriesList = graph.getPossibleObject(sourceDataset, jfree.Dataset_seriesList)) != null) {
                                ListUtils.removeElement((WriteGraph)graph, (Resource)sourceSeriesList, (Resource)source);
                            }
                            graph.deny(source, l0.PartOf);
                            Resource targetSeriesList = graph.getPossibleObject(target, jfree.Dataset_seriesList);
                            if (targetSeriesList == null) {
                                targetSeriesList = ListUtils.create((WriteGraph)graph, Collections.emptyList());
                                graph.claim(target, jfree.Dataset_seriesList, targetSeriesList);
                            }
                            if (droppedOnSeries != null) {
                                List list = ListUtils.toList((ReadGraph)graph, (Resource)targetSeriesList);
                                int targetIndex = list.indexOf(droppedOnSeries);
                                if (list.contains(source)) {
                                    list.remove(source);
                                }
                                list.add(targetIndex, source);
                                graph.deny(target, jfree.Dataset_seriesList);
                                targetSeriesList = ListUtils.create((WriteGraph)graph, (Iterable)list);
                                graph.claim(target, jfree.Dataset_seriesList, targetSeriesList);
                            } else {
                                ListUtils.insertFront((WriteGraph)graph, (Resource)targetSeriesList, Collections.singleton(source));
                            }
                            graph.claim(target, l0.ConsistsOf, source);
                        }
                    }
                });
            }
        };
        return runnable;
    }
}

