/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart.chart;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.util.Collection;
import javax.swing.SwingUtilities;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.ui.RectangleInsets;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.PossibleObjectWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.jfreechart.chart.IJFreeChart;
import org.simantics.jfreechart.chart.IPlot;
import org.simantics.jfreechart.chart.ITitle;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.JFreeChartResource;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.datastructures.Pair;

public class JFreeChart
implements IJFreeChart {
    private org.jfree.chart.JFreeChart jfreechart;
    private IPlot plot;
    private ITitle title;
    private Resource chartResource;
    JFreeChartListener listener;

    public JFreeChart(ReadGraph graph, Resource chartResource) {
        this.chartResource = chartResource;
        try {
            JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
            Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
            Collection plotsCollection = (Collection)graph.syncRequest((Read)new ObjectsWithType(chartResource, l0.ConsistsOf, jfree.Plot));
            for (Resource plotResource : plotsCollection) {
                this.plot = (IPlot)graph.adapt(plotResource, IPlot.class);
            }
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    @Override
    public org.jfree.chart.JFreeChart getChart() {
        if (this.plot == null) {
            return null;
        }
        if (this.jfreechart == null) {
            this.jfreechart = new org.jfree.chart.JFreeChart(this.plot.getPlot());
        }
        if (this.listener == null) {
            this.listener = new JFreeChartListener();
            SimanticsUI.getSession().asyncRequest((Read)new Read<Pair<ITitle, Boolean>>(){

                public Pair<ITitle, Boolean> perform(ReadGraph graph) throws DatabaseException {
                    if (JFreeChart.this.chartResource == null || !graph.hasStatement(JFreeChart.this.chartResource)) {
                        return null;
                    }
                    JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
                    Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                    Resource titleResource = (Resource)graph.syncRequest((Read)new PossibleObjectWithType(JFreeChart.this.chartResource, l0.ConsistsOf, jfree.Title));
                    JFreeChart.this.title = (ITitle)graph.adapt(titleResource, ITitle.class);
                    Boolean legendVisible = (Boolean)graph.getPossibleRelatedValue(JFreeChart.this.chartResource, jfree.Chart_visibleLegend, (Binding)Bindings.BOOLEAN);
                    return new Pair((Object)JFreeChart.this.title, (Object)legendVisible);
                }
            }, (Listener)this.listener);
        }
        return this.jfreechart;
    }

    @Override
    public void dispose() {
        if (this.title != null) {
            this.title.dispose();
        }
        if (this.listener != null) {
            this.listener.dispose();
        }
        if (this.plot != null) {
            this.plot.dispose();
        }
    }

    private class JFreeChartListener
    implements Listener<Pair<ITitle, Boolean>> {
        private boolean disposed = false;
        private LegendTitle legend;

        private JFreeChartListener() {
        }

        public void dispose() {
            this.disposed = true;
        }

        public void execute(final Pair<ITitle, Boolean> result) {
            if (result == null) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (JFreeChart.this.jfreechart == null) {
                        return;
                    }
                    JFreeChart.this.jfreechart.setBackgroundPaint((Paint)Color.WHITE);
                    if (JFreeChart.this.jfreechart.getLegend() != null && !JFreeChart.this.jfreechart.getLegend().equals((Object)JFreeChartListener.this.legend)) {
                        JFreeChartListener.this.legend = JFreeChart.this.jfreechart.getLegend();
                        JFreeChartListener.this.legend.setBorder(0.0, 0.0, 0.0, 0.0);
                        int size = JFreeChartListener.this.legend.getItemFont().getSize();
                        JFreeChartListener.this.legend.setItemFont(new Font("helvetica", 0, size));
                    }
                    if (Boolean.FALSE.equals(result.second)) {
                        JFreeChart.this.jfreechart.removeLegend();
                    } else if (JFreeChart.this.jfreechart.getLegend() == null && JFreeChartListener.this.legend != null) {
                        JFreeChart.this.jfreechart.addLegend(JFreeChartListener.this.legend);
                    }
                    TextTitle t = (TextTitle)((ITitle)result.first).getTitle();
                    if (t.isVisible()) {
                        t.setFont(new Font("georgia", 1, 13));
                        t.setPadding(new RectangleInsets(4.0, 0.0, 0.0, 0.0));
                        JFreeChart.this.jfreechart.setTitle(t);
                    } else {
                        JFreeChart.this.jfreechart.setTitle(null);
                    }
                }
            });
        }

        public void exception(Throwable t) {
            t.printStackTrace();
        }

        public boolean isDisposed() {
            return this.disposed;
        }
    }
}

