/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures.slice;

public class ValueRange {
    public static final ValueRange NO_RANGE = new ValueRange(0, Integer.MAX_VALUE);
    public static final ValueRange EMPTY = new ValueRange(0, 0);
    public static final ValueRange ONE = new ValueRange(0, 1);
    public static final ValueRange TWO = new ValueRange(0, 2);
    private final int start;
    private final int size;

    public static ValueRange make(int size) {
        if (size == 0) {
            return EMPTY;
        }
        if (size == 1) {
            return ONE;
        }
        if (size == 2) {
            return TWO;
        }
        return new ValueRange(size);
    }

    public static ValueRange make(int start, int size) {
        if (start == 0) {
            if (size == 0) {
                return EMPTY;
            }
            if (size == 1) {
                return ONE;
            }
            if (size == 2) {
                return TWO;
            }
        }
        return new ValueRange(start, size);
    }

    private ValueRange(int size) {
        this(0, size);
    }

    private ValueRange(int start, int size) {
        if (start < 0) {
            throw new IllegalArgumentException("negative range start: " + start);
        }
        if (size < 0) {
            throw new IllegalArgumentException("negative range size: " + size);
        }
        this.start = start;
        this.size = size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean isSingle() {
        return this.size == 1;
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.start + this.size;
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        if (this.isSingle()) {
            return "[" + this.start + "]";
        }
        return "[" + this.start + "-" + (this.start + this.size - 1) + "]";
    }

    public String toString(int offset) {
        if (this.isEmpty()) {
            return "[]";
        }
        if (this.isSingle()) {
            return "[" + (this.start + offset) + "]";
        }
        return "[" + (this.start + offset) + "-" + (this.start + this.size - 1 + offset) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.size;
        result = 31 * result + this.start;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValueRange other = (ValueRange)obj;
        return this.size == other.size && this.start == other.start;
    }

    public String toChildReferenceString() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("cannot create a value reference for an empty range");
        }
        StringBuilder sb = new StringBuilder();
        if (this.isSingle()) {
            return sb.append("i-").append(this.start).toString();
        }
        return sb.append("r-").append(this.start).append('-').append(this.start + this.size - 1).toString();
    }
}

