/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures.persistent;

public abstract class ImmutableStack<T> {
    static final EmptyStack EMPTY = new EmptyStack();

    private ImmutableStack() {
    }

    public ImmutableStack<T> push(T value) {
        return new SingleStackNode<T>(this, value);
    }

    public ImmutableStack<T> push(T[] values) {
        if (values.length > 1) {
            return new MultiStackNode<T>(this, values);
        }
        if (values.length == 1) {
            return new SingleStackNode<T>(this, values[0]);
        }
        return this;
    }

    public abstract T get(int var1);

    public static <T> ImmutableStack<T> empty() {
        return EMPTY;
    }

    public static <T> ImmutableStack<T> of(T value) {
        return new SingleStackNode<T>(null, value);
    }

    public static <T> ImmutableStack<T> of(T[] values) {
        if (values.length > 1) {
            return new MultiStackNode<T>(ImmutableStack.<T>empty(), values);
        }
        if (values.length == 1) {
            return new SingleStackNode<T>(ImmutableStack.<T>empty(), values[0]);
        }
        return ImmutableStack.empty();
    }

    /* synthetic */ ImmutableStack(ImmutableStack immutableStack) {
        this();
    }

    private static class EmptyStack<T>
    extends ImmutableStack<T> {
        private EmptyStack() {
            super(null);
        }

        @Override
        public T get(int i) {
            throw new IllegalArgumentException("No such element in stack.");
        }
    }

    private static class MultiStackNode<T>
    extends ImmutableStack<T> {
        ImmutableStack<T> parent;
        T[] values;

        public MultiStackNode(ImmutableStack<T> parent, T[] values) {
            super(null);
            this.parent = parent;
            this.values = values;
        }

        @Override
        public T get(int i) {
            return i < this.values.length ? this.values[i] : this.parent.get(i - this.values.length);
        }
    }

    private static class SingleStackNode<T>
    extends ImmutableStack<T> {
        ImmutableStack<T> parent;
        T value;

        public SingleStackNode(ImmutableStack<T> parent, T value) {
            super(null);
            this.parent = parent;
            this.value = value;
        }

        @Override
        public T get(int i) {
            return i == 0 ? this.value : this.parent.get(i - 1);
        }
    }
}

