/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures.map;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;

public class Tuple
implements Serializable,
Externalizable {
    Object[] fields;
    private int hashCode;
    int associativity;

    Tuple() {
    }

    public Tuple(Object ... fields) {
        this.fields = fields;
        this.hashCode = Arrays.hashCode(fields);
        int mask = 1;
        Object[] objectArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o != null) {
                this.associativity |= mask;
            }
            mask <<= 1;
            ++n2;
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        Tuple other = (Tuple)obj;
        return Arrays.deepEquals(this.fields, other.fields);
    }

    public String toString() {
        return Arrays.toString(this.fields);
    }

    public Object getField(int index) {
        return this.fields[index];
    }

    public <T> T getTypedField(int index) {
        return (T)this.fields[index];
    }

    public Object[] getFields() {
        return this.fields;
    }

    public int getLevel() {
        return this.fields.length;
    }

    public int getAssociativity() {
        return this.associativity;
    }

    public boolean isFull() {
        return this.associativity == (1 << this.fields.length) - 1;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int count = in.readInt();
        this.fields = new Object[count];
        int i = 0;
        while (i < count) {
            this.fields[i] = in.readObject();
            ++i;
        }
        this.hashCode = Arrays.hashCode(this.fields);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.fields.length);
        Object[] objectArray = this.fields;
        int n = this.fields.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            out.writeObject(o);
            ++n2;
        }
    }
}

