/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.simantics.utils.datastructures.ImmutableIterator;
import org.simantics.utils.datastructures.ImmutableSet;

public class ArrayMap<K, V>
implements Map<K, V> {
    K[] keys;
    V[] values;
    Set<Map.Entry<K, V>> entrySet;
    Set<K> keySet;
    Collection<V> valueSet;

    public static <K2, V2> ArrayMapBuilder<K2, V2> keys(K2 ... keys) {
        return new ArrayMapBuilder(keys);
    }

    public static <K2, V2> ArrayMap<K2, V2> make(K2[] keys, V2 ... values) {
        return new ArrayMap<K2, V2>(keys, values);
    }

    public ArrayMap(K[] keys, V[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("key array size (" + keys.length + ") != value array size (" + values.length + ")");
        }
        this.keys = keys;
        this.values = values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet != null ? this.entrySet : (this.entrySet = new EntrySet());
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keySet().contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            int i = 0;
            while (i < this.keys.length) {
                if (this.keys[i] == null) {
                    return this.values[i];
                }
                ++i;
            }
            return null;
        }
        int hash = key.hashCode();
        int i = 0;
        while (i < this.keys.length) {
            K k = this.keys[i];
            if (k == key || hash == k.hashCode() && key.equals(k)) {
                return this.values[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.keys.length == 0;
    }

    @Override
    public Set<K> keySet() {
        return this.keySet != null ? this.keySet : (this.keySet = new KeySet());
    }

    @Override
    public V put(K key, V value) {
        if (key == null) {
            int i = 0;
            while (i < this.keys.length) {
                if (this.keys[i] == null) {
                    V old = this.values[i];
                    this.values[i] = value;
                    return old;
                }
                ++i;
            }
            throw new UnsupportedOperationException("key " + key + " not present in ArrayMap");
        }
        int hash = key.hashCode();
        int i = 0;
        while (i < this.keys.length) {
            K k = this.keys[i];
            if (k == key || hash == k.hashCode() && key.equals(k)) {
                V old = this.values[i];
                this.values[i] = value;
                return old;
            }
            ++i;
        }
        throw new UnsupportedOperationException("key " + key + " not present in ArrayMap");
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (K k : m.keySet()) {
            if (this.containsKey(k)) continue;
            throw new UnsupportedOperationException("key " + k + " not present in ArrayMap");
        }
        for (Map.Entry entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.keys.length;
    }

    @Override
    public Collection<V> values() {
        return this.valueSet != null ? this.valueSet : (this.valueSet = Collections.unmodifiableCollection(Arrays.asList(this.values)));
    }

    @Override
    public int hashCode() {
        int h = 0;
        Iterator<Map.Entry<K, V>> i = this.entrySet().iterator();
        while (i.hasNext()) {
            h += i.next().hashCode();
        }
        return h;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        try {
            Iterator<Map.Entry<K, V>> i = this.entrySet().iterator();
            while (true) {
                if (!i.hasNext()) {
                    return true;
                }
                Map.Entry<K, V> e = i.next();
                K key = e.getKey();
                V value = e.getValue();
                if (value == null) {
                    if (m.get(key) != null) return false;
                    if (m.containsKey(key)) continue;
                    return false;
                }
                if (!value.equals(m.get(key))) break;
            }
            return false;
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
    }

    public String toString() {
        Iterator<Map.Entry<K, V>> i = this.entrySet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            Map.Entry<K, V> e = i.next();
            K key = e.getKey();
            V value = e.getValue();
            sb.append((Object)(key == this ? "(this Map)" : key));
            sb.append('=');
            sb.append((Object)(value == this ? "(this Map)" : value));
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(", ");
        }
    }

    public static class ArrayMapBuilder<K2, V2> {
        private final K2[] keys;

        ArrayMapBuilder(K2[] keys) {
            this.keys = keys;
        }

        public ArrayMap<K2, V2> values(V2 ... values) {
            return new ArrayMap<K2, V2>(this.keys, values);
        }
    }

    static class Entry<K, V>
    implements Map.Entry<K, V> {
        final K key;
        V value;

        Entry(int h, K k, V v) {
            this.value = v;
            this.key = k;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        @Override
        public final V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public final boolean equals(Object o) {
            Object v2;
            V v1;
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            K k1 = this.getKey();
            return (k1 == (k2 = e.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public final int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public final String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    class EntrySet
    extends ImmutableSet<Map.Entry<K, V>>
    implements Set<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException("TODO");
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object o : c) {
                if (this.contains(o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            return ArrayMap.this.keys.length == 0;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new ImmutableIterator<Map.Entry<K, V>>(){
                int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < ((EntrySet)EntrySet.this).ArrayMap.this.keys.length;
                }

                @Override
                public Map.Entry<K, V> next() {
                    if (this.i >= ((EntrySet)EntrySet.this).ArrayMap.this.keys.length) {
                        throw new NoSuchElementException("no more elements (" + ((EntrySet)EntrySet.this).ArrayMap.this.keys.length + " walked)");
                    }
                    Entry entry = new Entry(this.i, ((EntrySet)EntrySet.this).ArrayMap.this.keys[this.i], ((EntrySet)EntrySet.this).ArrayMap.this.values[this.i]);
                    ++this.i;
                    return entry;
                }
            };
        }

        @Override
        public int size() {
            return ArrayMap.this.keys.length;
        }
    }

    class KeySet
    extends ImmutableSet<K>
    implements Set<K> {
        KeySet() {
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                K[] KArray = ArrayMap.this.keys;
                int n = ArrayMap.this.keys.length;
                int n2 = 0;
                while (n2 < n) {
                    Object k = KArray[n2];
                    if (k == null) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
            int hash = o.hashCode();
            K[] KArray = ArrayMap.this.keys;
            int n = ArrayMap.this.keys.length;
            int n3 = 0;
            while (n3 < n) {
                Object k = KArray[n3];
                if (o == k || hash == k.hashCode() && o.equals(k)) {
                    return true;
                }
                ++n3;
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object o : c) {
                if (this.contains(o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            return ArrayMap.this.keys.length == 0;
        }

        @Override
        public Iterator<K> iterator() {
            return new ImmutableIterator<K>(){
                int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < ((KeySet)KeySet.this).ArrayMap.this.keys.length;
                }

                @Override
                public K next() {
                    if (this.i >= ((KeySet)KeySet.this).ArrayMap.this.keys.length) {
                        throw new NoSuchElementException("no more elements (" + ((KeySet)KeySet.this).ArrayMap.this.keys.length + " walked)");
                    }
                    Object k = ((KeySet)KeySet.this).ArrayMap.this.keys[this.i];
                    ++this.i;
                    return k;
                }
            };
        }

        @Override
        public int size() {
            return ArrayMap.this.keys.length;
        }

        @Override
        public Object[] toArray() {
            return ArrayMap.this.keys;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            if (a.length < ArrayMap.this.keys.length) {
                return Arrays.copyOf(ArrayMap.this.keys, ArrayMap.this.keys.length, a.getClass());
            }
            System.arraycopy(ArrayMap.this.keys, 0, a, 0, ArrayMap.this.keys.length);
            if (a.length > ArrayMap.this.keys.length) {
                a[ArrayMap.this.keys.length] = null;
            }
            return a;
        }
    }
}

