/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.layer0.utils.writer;

import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.utils.writer.GraphWriter;
import org.simantics.layer0.utils.writer.GraphWriterPartial;

public abstract class AbstractDelayedGraphWriter
extends GraphWriterPartial {
    protected int current = 0;
    int externalCount = 0;
    protected int internalCount = 0;
    ArrayList<Resource> externals = new ArrayList();
    protected TObjectIntHashMap<Resource> externalsInv = new TObjectIntHashMap();
    protected TIntObjectHashMap<Resource> inverses = new TIntObjectHashMap();
    TIntArrayList timestamps = new TIntArrayList();
    long[] resourceIds;
    int time = 0;

    public long getResourceId(Session session, Resource r) {
        if (r instanceof InternalResource) {
            if (this.resourceIds == null) {
                System.out.println("ERROR. Requesting resource id for new resource in writer before ids have been assigned.");
                return 0L;
            }
            return this.resourceIds[((InternalResource)r).id - 1];
        }
        return r.getResourceId();
    }

    public AbstractDelayedGraphWriter(ReadGraph graph) {
        super(graph);
    }

    @Override
    public GraphWriter create() {
        this.current = ++this.internalCount;
        this.timestamps.add(0);
        return this;
    }

    @Override
    public Resource get() {
        if (this.current > 0) {
            return new InternalResource(this.current);
        }
        if (this.current < 0) {
            return this.externals.get(-1 - this.current);
        }
        return null;
    }

    protected int getId(Resource r) {
        if (r instanceof InternalResource) {
            return ((InternalResource)r).id;
        }
        int id = this.externalsInv.get((Object)r);
        if (id == 0) {
            id = -(++this.externalCount);
            this.externals.add(r);
            this.externalsInv.put((Object)r, id);
        }
        return id;
    }

    @Override
    public GraphWriter handle(Resource s) {
        this.current = this.getId(s);
        return this;
    }

    protected int getPredicateId(Resource p) throws DatabaseException {
        int pId = this.getId(p);
        if (!this.inverses.contains(pId) && !(p instanceof InternalResource)) {
            this.inverses.put(pId, (Object)this.graph.getInverse(p));
        }
        return pId;
    }

    public abstract void commit(IProgressMonitor var1, WriteOnlyGraph var2) throws DatabaseException;

    protected static class InternalResource
    implements Resource {
        int id;

        public InternalResource(int id) {
            this.id = id;
        }

        public long getResourceId() {
            return this.id;
        }

        public Resource get() {
            return this;
        }

        public boolean isPersistent() {
            return false;
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof InternalResource && ((InternalResource)obj).id == this.id;
        }

        public boolean equalsResource(Resource other) {
            return this.equals(other);
        }

        public int hashCode() {
            return this.id;
        }

        public int getThreadHash() {
            return this.id >>> 16;
        }

        public int compareTo(Resource o) {
            if (this == o) {
                return 0;
            }
            if (o instanceof InternalResource) {
                return this.id - ((InternalResource)o).id;
            }
            return -1;
        }
    }
}

