/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.layer0.utils.requirements;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.simantics.layer0.utils.requirements.IntegerRange;

public class IntegerRangeUnion {
    List<IntegerRange> ranges = new ArrayList<IntegerRange>();

    public IntegerRangeUnion() {
    }

    public IntegerRangeUnion(String spec) {
        String[] stringArray = spec.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String rangeStr = stringArray[n2];
            String[] rangeSplit = rangeStr.split("\\.\\.");
            if (rangeSplit.length == 1) {
                if (rangeSplit[0].equals("*")) {
                    this.ranges.add(new IntegerRange(0, IntegerRange.INFINITY));
                } else {
                    int bound = Integer.parseInt(rangeSplit[0]);
                    this.ranges.add(new IntegerRange(bound, bound));
                }
            } else if (rangeSplit.length == 2) {
                int lowerBound = 0;
                if (!rangeSplit[0].equals("*")) {
                    lowerBound = Integer.parseInt(rangeSplit[0]);
                }
                int upperBound = IntegerRange.INFINITY;
                if (!rangeSplit[1].equals("*")) {
                    upperBound = Integer.parseInt(rangeSplit[1]);
                }
                this.ranges.add(new IntegerRange(lowerBound, upperBound));
            }
            ++n2;
        }
    }

    public IntegerRangeUnion(int lowerBound, int upperBound) {
        this.ranges.add(new IntegerRange(lowerBound, upperBound));
    }

    public IntegerRangeUnion intersect(IntegerRangeUnion ru) {
        IntegerRangeUnion ret = new IntegerRangeUnion();
        Iterator<IntegerRange> it1 = this.ranges.iterator();
        Iterator<IntegerRange> it2 = ru.ranges.iterator();
        IntegerRange range1 = null;
        IntegerRange range2 = null;
        while (true) {
            int upper;
            if (range1 == null) {
                if (!it1.hasNext()) break;
                range1 = it1.next();
            }
            if (range2 == null) {
                if (!it2.hasNext()) break;
                range2 = it2.next();
            }
            int lower = Math.max(range1.lowerBound, range2.lowerBound);
            if (range1.upperBound < range2.upperBound) {
                upper = range1.upperBound;
                range1 = null;
            } else {
                upper = range2.upperBound;
                range1 = null;
            }
            if (lower > upper) continue;
            ret.ranges.add(new IntegerRange(lower, upper));
        }
        return ret;
    }

    public boolean contains(int i) {
        for (IntegerRange range : this.ranges) {
            if (!range.contains(i)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAllIntegers() {
        int c = -1;
        for (IntegerRange range : this.ranges) {
            if (range.lowerBound <= c + 1) {
                c = range.upperBound;
                continue;
            }
            return false;
        }
        return c == IntegerRange.INFINITY;
    }

    public boolean isEmpty() {
        return this.ranges.isEmpty();
    }

    public String toString() {
        if (this.ranges.isEmpty()) {
            return "*";
        }
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (IntegerRange range : this.ranges) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(range.toString());
        }
        return sb.toString();
    }

    public int getMinCardinality() {
        if (this.ranges.isEmpty()) {
            return 0;
        }
        return this.ranges.get((int)0).lowerBound;
    }
}

