/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.layer0.utils.predicates;

import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.predicates.UnaryPredicate;

public class SuperRelation
extends UnaryPredicate {
    Resource superrelation;

    public SuperRelation(Resource superrelation) {
        this.superrelation = superrelation;
    }

    @Override
    public Collection<Resource> getResources(ReadGraph g) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean has(ReadGraph g, Resource resource) throws DatabaseException {
        return g.isSubrelationOf(resource, this.superrelation);
    }

    @Override
    public boolean supportsUnboundedQuery() {
        return false;
    }

    @Override
    public void add(WriteGraph g, Resource r) throws DatabaseException {
        if (!g.isSubrelationOf(r, this.superrelation)) {
            Layer0 b = Layer0.getInstance((ReadGraph)g);
            g.claim(r, b.SubrelationOf, this.superrelation);
            if (!g.hasStatement(r, b.InverseOf)) {
                Resource invR = g.newResource();
                g.claim(r, b.InverseOf, invR);
                g.claim(invR, b.SubrelationOf, g.getInverse(this.superrelation));
            }
        }
    }

    @Override
    public void remove(WriteGraph g, Resource r) throws DatabaseException {
        Layer0 b = Layer0.getInstance((ReadGraph)g);
        if (g.isSubrelationOf(r, this.superrelation)) {
            g.denyStatement(r, b.SubrelationOf, this.superrelation);
        }
    }

    @Override
    public boolean supportsAddition() {
        return true;
    }

    @Override
    public boolean supportsRemoval() {
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.superrelation == null ? 0 : this.superrelation.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SuperRelation other = (SuperRelation)obj;
        return !(this.superrelation == null ? other.superrelation != null : !this.superrelation.equals(other.superrelation));
    }
}

