/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.layer0.utils.predicates;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.utils.predicates.IUnaryPredicate;
import org.simantics.layer0.utils.predicates.UnaryPredicate;

public class Conjunction
extends UnaryPredicate {
    Collection<IUnaryPredicate> predicates;
    IUnaryPredicate support;

    public Conjunction(Collection<IUnaryPredicate> predicates) {
        for (IUnaryPredicate pred : predicates) {
            if (!pred.supportsUnboundedQuery()) continue;
            this.support = pred;
            this.predicates = new ArrayList<IUnaryPredicate>(predicates.size() - 1);
            for (IUnaryPredicate pred2 : predicates) {
                if (pred == pred2) continue;
                this.predicates.add(pred2);
            }
            return;
        }
        this.predicates = predicates;
        this.support = null;
    }

    public Conjunction(IUnaryPredicate ... predicates) {
        this(Arrays.asList(predicates));
    }

    @Override
    public Collection<Resource> getResources(ReadGraph g) throws DatabaseException {
        ArrayList<Resource> result = new ArrayList<Resource>();
        block0: for (Resource r : this.support.getResources(g)) {
            for (IUnaryPredicate pred : this.predicates) {
                if (!pred.has(g, r)) continue block0;
            }
            result.add(r);
        }
        return result;
    }

    @Override
    public boolean has(ReadGraph g, Resource resource) throws DatabaseException {
        for (IUnaryPredicate pred : this.predicates) {
            if (pred.has(g, resource)) continue;
            return false;
        }
        return this.support == null || this.support.has(g, resource);
    }

    @Override
    public boolean supportsUnboundedQuery() {
        return this.support != null;
    }

    @Override
    public void add(WriteGraph g, Resource r) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(WriteGraph g, Resource r) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsAddition() {
        return false;
    }

    @Override
    public boolean supportsRemoval() {
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.predicates == null ? 0 : this.predicates.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Conjunction other = (Conjunction)obj;
        return !(this.predicates == null ? other.predicates != null : !this.predicates.equals(other.predicates));
    }
}

