/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.layer0.utils.instantiation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.RequirementResource;
import org.simantics.layer0.utils.requirements.IntegerRangeUnion;

public class LocalRequirements {
    public Set<Resource> elements = new HashSet<Resource>();
    public List<Resource> types = new LinkedList<Resource>();
    public List<ForAll> forAll = new ArrayList<ForAll>();
    public List<Cardinality> cardinalities = new ArrayList<Cardinality>();

    public void addType(ReadGraph graph, Resource type) throws DatabaseException {
        RequirementResource REQ = RequirementResource.getInstance((ReadGraph)graph);
        Iterator<Resource> it = this.types.iterator();
        while (it.hasNext()) {
            Resource t = it.next();
            if (t.equals(type) || graph.isInheritedFrom(t, type)) {
                return;
            }
            if (!graph.isInheritedFrom(type, t)) continue;
            it.remove();
        }
        this.types.add(type);
        for (Resource req : graph.getObjects((Resource)type.get(), REQ.HasRequirement)) {
            this.addRequirement(graph, req);
        }
    }

    public void addRequirement(ReadGraph graph, Resource requirement) throws DatabaseException {
        block7: {
            RequirementResource REQ;
            block9: {
                Layer0 l0;
                block8: {
                    block6: {
                        l0 = Layer0.getInstance((ReadGraph)graph);
                        REQ = RequirementResource.getInstance((ReadGraph)graph);
                        if (!graph.isInstanceOf(requirement, REQ.RequirementConjunction)) break block6;
                        for (Resource subreq : graph.getObjects(requirement, REQ.HasRequirement)) {
                            this.addRequirement(graph, subreq);
                        }
                        break block7;
                    }
                    if (!graph.isInstanceOf(requirement, REQ.TypeRequirement)) break block8;
                    for (Resource type : graph.getObjects(requirement, REQ.HasType)) {
                        this.addType(graph, type);
                    }
                    break block7;
                }
                if (!graph.isInstanceOf(requirement, REQ.RelationRequirement)) break block9;
                for (Resource relation : graph.getObjects(requirement, l0.ConcernsRelation)) {
                    IntegerRangeUnion range;
                    int minCard;
                    String cardinality = (String)graph.getPossibleRelatedValue(requirement, l0.HasCardinalityRange);
                    if (cardinality != null && (minCard = (range = new IntegerRangeUnion(cardinality)).getMinCardinality()) > 0) {
                        this.addCardinality(graph, relation, minCard);
                    }
                    for (Resource req : graph.getObjects(requirement, REQ.AllValuesSatisfy)) {
                        this.forAll.add(new ForAll(relation, req));
                    }
                }
                break block7;
            }
            if (!graph.isInstanceOf(requirement, REQ.EqualityRequirement)) break block7;
            for (Resource type : graph.getObjects(requirement, REQ.HasEntity)) {
                this.elements.add(type);
            }
        }
    }

    private void addCardinality(ReadGraph graph, Resource relation, int card) throws DatabaseException {
        Cardinality cur = null;
        for (Cardinality req : this.cardinalities) {
            if (relation.equals(req.relation)) {
                cur = req;
                card -= req.card;
                continue;
            }
            if (!graph.isSubrelationOf(req.relation, relation)) continue;
            card -= req.card;
        }
        if (card > 0) {
            if (cur == null) {
                cur = new Cardinality(relation, card);
                for (Cardinality c : this.cardinalities) {
                    if (!graph.isSubrelationOf(relation, c.relation)) continue;
                    cur.immediateSuperrelations.add(c);
                }
                Cardinality[] cardinalityArray = cur.immediateSuperrelations.toArray(new Cardinality[cur.immediateSuperrelations.size()]);
                int n = cardinalityArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Cardinality c;
                    c = cardinalityArray[n2];
                    c.prune(cur.immediateSuperrelations);
                    ++n2;
                }
                this.cardinalities.add(cur);
            } else {
                cur.card += card;
            }
            for (Cardinality c : cur.immediateSuperrelations) {
                c.remove(card);
            }
        }
    }

    public LocalRequirements localRequirementsOfRelation(ReadGraph graph, Resource relation) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        LocalRequirements ret = new LocalRequirements();
        for (ForAll f : this.forAll) {
            if (!graph.isSubrelationOf(relation, f.relation)) continue;
            ret.addRequirement(graph, f.requirement);
        }
        for (Resource r : graph.getObjects(relation, l0.HasRange)) {
            ret.addRequirement(graph, r);
        }
        return ret;
    }

    public static LocalRequirements localRequirementsOfType(ReadGraph graph, Resource type) throws DatabaseException {
        LocalRequirements ret = new LocalRequirements();
        ret.addType(graph, type);
        return ret;
    }

    public static class Cardinality {
        public Resource relation;
        public int card;
        public Set<Cardinality> immediateSuperrelations = new HashSet<Cardinality>();

        public Cardinality(Resource relation, int card) {
            this.relation = relation;
            this.card = card;
        }

        int remove(int c) {
            if (this.card >= c) {
                this.card -= c;
                return 0;
            }
            c -= this.card;
            this.card = 0;
            for (Cardinality req : this.immediateSuperrelations) {
                c = req.remove(c);
                if (c == 0) break;
            }
            return c;
        }

        public void prune(Set<Cardinality> set) {
            for (Cardinality c : this.immediateSuperrelations) {
                set.remove(c);
            }
        }
    }

    public static class ForAll {
        Resource relation;
        Resource requirement;

        public ForAll(Resource relation, Resource requirement) {
            this.relation = relation;
            this.requirement = requirement;
        }
    }
}

