/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.layer0.utils.instantiation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.AssumptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.instantiation.Instance;
import org.simantics.layer0.utils.instantiation.LocalRequirements;
import org.simantics.layer0.utils.instantiation.MultiInstance;
import org.simantics.operation.Layer0X;

public class InstanceFactory {
    private static Map<Resource, Instance> typeInstanceCache = new HashMap<Resource, Instance>();
    private static Map<Resource, Instance> defaultInstanceCache = new HashMap<Resource, Instance>();

    public static Instance getInstanceOfType(ReadGraph graph, Resource type) throws DatabaseException {
        Instance ret = typeInstanceCache.get(type);
        if (ret == null) {
            ret = InstanceFactory.createInstanceOfType(graph, type);
            typeInstanceCache.put(type, ret);
        }
        return ret;
    }

    public static Resource instantiate(WriteGraph graph, Resource type) throws DatabaseException {
        return InstanceFactory.getInstanceOfType((ReadGraph)graph, type).instantiate(graph);
    }

    public static Resource instantiate(WriteGraph graph, Collection<Resource> types) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        ArrayList<Instance> instances = new ArrayList<Instance>();
        for (Resource type : types) {
            instances.add(InstanceFactory.getInstanceOfType((ReadGraph)graph, type));
        }
        MultiInstance mi = new MultiInstance(instances, l0.InstanceOf);
        return mi.instantiate(graph);
    }

    public static Resource instantiateUsing(WriteGraph graph, Resource instance, Resource type) throws DatabaseException {
        return InstanceFactory.getInstanceOfType((ReadGraph)graph, type).instantiateUsing(graph, instance);
    }

    private static Instance createInstanceOfType(ReadGraph graph, Resource type) throws DatabaseException {
        Instance ret = InstanceFactory.getDefaultValueOfType(graph, type);
        if (ret == null) {
            return InstanceFactory.createInstanceOfLocalRequirements(graph, LocalRequirements.localRequirementsOfType(graph, type));
        }
        return ret;
    }

    private static Instance getDefaultValueOfType(ReadGraph graph, Resource type) throws DatabaseException {
        if (defaultInstanceCache.containsKey(type)) {
            return defaultInstanceCache.get(type);
        }
        Instance ret = InstanceFactory.createDefaultValueOfType(graph, type);
        defaultInstanceCache.put(type, ret);
        return ret;
    }

    private static Instance createDefaultValueOfType(ReadGraph graph, Resource type) throws DatabaseException {
        Iterator iterator = graph.getObjects(type, Layer0X.getInstance((ReadGraph)graph).HasDefaultValue).iterator();
        if (iterator.hasNext()) {
            Resource def = (Resource)iterator.next();
            return InstanceFactory.createInstanceOfProperty(graph, def);
        }
        return null;
    }

    private static Instance createInstanceOfProperty(ReadGraph graph, Resource property) throws DatabaseException {
        Instance ret = new Instance();
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        for (Statement statement : graph.getStatements(property, l0.IsRelatedTo)) {
            Instance.RelatedInstance instance;
            if (!statement.getSubject().equals(property)) continue;
            if (graph.isSubrelationOf(statement.getPredicate(), l0.IsComposedOf)) {
                instance = new Instance.RelatedInstance();
                instance.relation = statement.getPredicate();
                instance.cardinality = 1;
                instance.instance = InstanceFactory.createInstanceOfProperty(graph, statement.getObject());
                ret.relatedInstances.add(instance);
                continue;
            }
            instance = new Instance.RelatedInstance();
            instance.relation = statement.getPredicate();
            instance.cardinality = 1;
            instance.instance = new Instance(statement.getObject());
            ret.relatedInstances.add(instance);
        }
        if (graph.hasValue(property)) {
            ret.value = graph.getValue(property);
        }
        return ret;
    }

    private static Instance createInstanceOfLocalRequirements(ReadGraph graph, LocalRequirements reqs) throws DatabaseException {
        Instance.RelatedInstance instance;
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Instance ret = new Instance();
        if (!reqs.elements.isEmpty()) {
            for (Resource r : reqs.elements) {
                if (ret.equals != null) {
                    throw new AssumptionException("");
                }
                ret.equals = r;
            }
        }
        for (Resource t : reqs.types) {
            Instance def = InstanceFactory.getDefaultValueOfType(graph, t);
            if (def == null) continue;
            return def;
        }
        for (Resource type : reqs.types) {
            instance = new Instance.RelatedInstance();
            instance.cardinality = 1;
            instance.relation = l0.InstanceOf;
            instance.instance = new Instance(type);
            ret.relatedInstances.add(instance);
        }
        for (LocalRequirements.Cardinality c : reqs.cardinalities) {
            instance = new Instance.RelatedInstance();
            instance.cardinality = c.card;
            instance.relation = c.relation;
            instance.instance = InstanceFactory.createInstanceOfLocalRequirements(graph, reqs.localRequirementsOfRelation(graph, c.relation));
            ret.relatedInstances.add(instance);
        }
        for (Resource t : reqs.types) {
            if (!graph.isInheritedFrom(t, l0.Literal)) continue;
            ret.value = InstanceFactory.createDefaultValue(graph, t);
            break;
        }
        return ret;
    }

    private static Object createDefaultValue(ReadGraph graph, Resource t) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        if (graph.isInheritedFrom(t, l0.String)) {
            return " ";
        }
        if (graph.isInheritedFrom(t, l0.Double)) {
            return 0.0;
        }
        if (graph.isInheritedFrom(t, l0.Float)) {
            return Float.valueOf(0.0f);
        }
        if (graph.isInheritedFrom(t, l0.Integer)) {
            return 0;
        }
        if (graph.isInheritedFrom(t, l0.Long)) {
            return 0L;
        }
        if (graph.isInheritedFrom(t, l0.Boolean)) {
            return Boolean.FALSE;
        }
        if (graph.isInheritedFrom(t, l0.Byte)) {
            return (byte)0;
        }
        return null;
    }
}

