/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.layer0.utils.genericPredicates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.utils.genericPredicates.IPredicate;
import org.simantics.layer0.utils.genericPredicates.IPredicateQuery;
import org.simantics.layer0.utils.genericPredicates.IRule;
import org.simantics.layer0.utils.genericPredicates.IUnaryPredicate2;

public class UnaryPredicateAdapter
implements IUnaryPredicate2 {
    static final int[] VARIABLE_LIST = new int[1];
    IPredicate predicate;

    public UnaryPredicateAdapter(IPredicate predicate) {
        if (predicate.arity() != 1) {
            throw new IllegalArgumentException("Predicate " + predicate + " is not unary.");
        }
        this.predicate = predicate;
    }

    @Override
    public void claim(WriteGraph g, Object v0) throws DatabaseException {
        this.predicate.claim(VARIABLE_LIST).doExecute(g, new Object[]{v0});
    }

    @Override
    public void deny(WriteGraph g, Object v0) throws DatabaseException {
        this.predicate.deny(VARIABLE_LIST).doExecute(g, new Object[]{v0});
    }

    @Override
    public Collection<Object> get(ReadGraph g) throws DatabaseException {
        Object[] bindings;
        IPredicateQuery query = this.predicate.query(VARIABLE_LIST, 0);
        Object cont = query.query(g, bindings = new Object[1]);
        if (cont == IPredicateQuery.FAILURE) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        do {
            result.add(bindings[0]);
            if (cont != null) continue;
            return result;
        } while ((cont = query.query(g, bindings)) != IPredicateQuery.FAILURE);
        return result;
    }

    @Override
    public boolean has(ReadGraph g, Object v0) throws DatabaseException {
        return this.predicate.query(VARIABLE_LIST, 1).query(g, new Object[]{v0}) != IPredicateQuery.FAILURE;
    }

    @Override
    public boolean supportsClaim() {
        return this.predicate.claim(VARIABLE_LIST) != null;
    }

    @Override
    public boolean supportsDeny() {
        return this.predicate.deny(VARIABLE_LIST) != null;
    }

    @Override
    public boolean supportsGet() {
        return this.predicate.query(VARIABLE_LIST, 0) != null;
    }

    @Override
    public int arity() {
        return 1;
    }

    @Override
    public IRule claim(int[] variables) {
        return this.predicate.claim(variables);
    }

    @Override
    public IRule deny(int[] variables) {
        return this.predicate.deny(variables);
    }

    @Override
    public IPredicateQuery query(int[] variables, int boundVariables) {
        return this.predicate.query(variables, boundVariables);
    }

    public int hashCode() {
        return this.getClass().hashCode() + 31 * this.predicate.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        UnaryPredicateAdapter other = (UnaryPredicateAdapter)obj;
        return this.predicate.equals(other.predicate);
    }
}

