/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.layer0.utils.genericPredicates;

import java.util.ArrayList;
import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.genericPredicates.IContextualModification;
import org.simantics.layer0.utils.genericPredicates.IPredicate;
import org.simantics.layer0.utils.genericPredicates.IPredicateQuery;
import org.simantics.layer0.utils.genericPredicates.IRule;
import org.simantics.layer0.utils.genericPredicates.PredicateQuery0;
import org.simantics.layer0.utils.genericPredicates.PredicateQuery1;
import org.simantics.layer0.utils.genericPredicates.PredicateQuery2;

public class TripletPredicate
implements IPredicate {
    @Override
    public int arity() {
        return 3;
    }

    @Override
    public IRule claim(int[] variables) {
        final int v0 = variables[0];
        final int v1 = variables[1];
        final int v2 = variables[2];
        return new IRule(){

            @Override
            public void doExecute(WriteGraph g, Object[] bindings) throws DatabaseException {
                Resource r0 = (Resource)bindings[v0];
                Resource r1 = (Resource)bindings[v1];
                Resource r2 = (Resource)bindings[v2];
                if (!g.hasStatement(r0, r1, r2)) {
                    g.claim(r0, r1, r2);
                }
            }

            @Override
            public IContextualModification execute(ReadGraph g, Object[] bindings) throws DatabaseException {
                Resource r0 = (Resource)bindings[v0];
                Resource r1 = (Resource)bindings[v1];
                Resource r2 = (Resource)bindings[v2];
                if (!g.hasStatement(r0, r1, r2)) {
                    return new IContextualModification(){

                        @Override
                        public boolean needsContext() {
                            return true;
                        }

                        @Override
                        public void perform(WriteGraph g, Object[] bindings) throws DatabaseException {
                            Resource r0 = (Resource)bindings[v0];
                            Resource r1 = (Resource)bindings[v1];
                            Resource r2 = (Resource)bindings[v2];
                            g.claim(r0, r1, r2);
                        }
                    };
                }
                return null;
            }
        };
    }

    @Override
    public IRule deny(int[] variables) {
        final int v0 = variables[0];
        final int v1 = variables[1];
        final int v2 = variables[2];
        return new IRule(){

            @Override
            public void doExecute(WriteGraph g, Object[] bindings) throws DatabaseException {
                Resource r0 = (Resource)bindings[v0];
                Resource r1 = (Resource)bindings[v1];
                Resource r2 = (Resource)bindings[v2];
                if (g.hasStatement(r0, r1, r2)) {
                    g.denyStatement(r0, r1, r2);
                }
            }

            @Override
            public IContextualModification execute(ReadGraph g, Object[] bindings) throws DatabaseException {
                Resource r0 = (Resource)bindings[v0];
                Resource r1 = (Resource)bindings[v1];
                Resource r2 = (Resource)bindings[v2];
                if (g.hasStatement(r0, r1, r2)) {
                    return new IContextualModification(){

                        @Override
                        public boolean needsContext() {
                            return true;
                        }

                        @Override
                        public void perform(WriteGraph g, Object[] bindings) throws DatabaseException {
                            Resource r0 = (Resource)bindings[v0];
                            Resource r1 = (Resource)bindings[v1];
                            Resource r2 = (Resource)bindings[v2];
                            g.denyStatement(r0, r1, r2);
                        }
                    };
                }
                return null;
            }
        };
    }

    @Override
    public IPredicateQuery query(int[] variables, int boundVariables) {
        final int v0 = variables[0];
        final int v1 = variables[1];
        final int v2 = variables[2];
        switch (boundVariables) {
            case 0: {
                return null;
            }
            case 1: {
                return new PredicateQuery2(v1, v2){

                    @Override
                    protected Collection<Object> getResult(ReadGraph g, Object[] bindings) throws DatabaseException {
                        Layer0 b = Layer0.getInstance((ReadGraph)g);
                        Collection result = g.getStatements((Resource)bindings[v0], b.IsWeaklyRelatedTo);
                        ArrayList<Object> pairs = new ArrayList<Object>(result.size() * 2);
                        for (Statement stat : result) {
                            pairs.add(stat.getPredicate());
                            pairs.add(stat.getObject());
                        }
                        return pairs;
                    }
                };
            }
            case 2: {
                return null;
            }
            case 3: {
                return new PredicateQuery1(v2){

                    @Override
                    protected Collection<Object> getResult(ReadGraph g, Object[] bindings) throws DatabaseException {
                        return g.getObjects((Resource)bindings[v0], (Resource)bindings[v1]);
                    }
                };
            }
            case 4: {
                return new PredicateQuery2(v0, v1){

                    @Override
                    protected Collection<Object> getResult(ReadGraph g, Object[] bindings) throws DatabaseException {
                        Layer0 b = Layer0.getInstance((ReadGraph)g);
                        Collection result = g.getStatements((Resource)bindings[v2], b.IsWeaklyRelatedTo);
                        ArrayList<Object> pairs = new ArrayList<Object>(result.size());
                        for (Statement stat : result) {
                            pairs.add(stat.getSubject());
                            pairs.add(stat.getPredicate());
                        }
                        return pairs;
                    }
                };
            }
            case 5: {
                return new PredicateQuery1(v1){

                    @Override
                    protected Collection<Object> getResult(ReadGraph g, Object[] bindings) throws DatabaseException {
                        ArrayList<Object> result = new ArrayList<Object>();
                        Resource r0 = (Resource)bindings[v0];
                        Resource r2 = (Resource)bindings[v2];
                        Layer0 b = Layer0.getInstance((ReadGraph)g);
                        for (Statement stat : g.getStatements(r0, b.IsWeaklyRelatedTo)) {
                            if (!stat.getObject().equals(r2) || result.contains(stat.getPredicate())) continue;
                            result.add(stat.getPredicate());
                        }
                        return result;
                    }
                };
            }
            case 6: {
                return new PredicateQuery1(v0){

                    @Override
                    protected Collection<Object> getResult(ReadGraph g, Object[] bindings) throws DatabaseException {
                        return g.getObjects((Resource)bindings[v2], g.getInverse((Resource)bindings[v1]));
                    }
                };
            }
            case 7: {
                return new PredicateQuery0(){

                    @Override
                    protected boolean getResult(ReadGraph g, Object[] bindings) throws DatabaseException {
                        return g.hasStatement((Resource)bindings[v0], (Resource)bindings[v1], (Resource)bindings[v2]);
                    }
                };
            }
        }
        throw new IllegalArgumentException("Invalid boundVariables=" + boundVariables + " for triplet predicate.");
    }
}

