/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.layer0.utils.genericPredicates;

import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.utils.genericPredicates.ContextualModification;
import org.simantics.layer0.utils.genericPredicates.IContextualModification;
import org.simantics.layer0.utils.genericPredicates.IRule;

class RuleConjunction
implements IRule {
    IRule[] rules;

    public RuleConjunction(IRule[] rules) {
        this.rules = rules;
    }

    @Override
    public void doExecute(WriteGraph g, Object[] bindings) throws DatabaseException {
        IRule[] iRuleArray = this.rules;
        int n = this.rules.length;
        int n2 = 0;
        while (n2 < n) {
            IRule rule = iRuleArray[n2];
            rule.doExecute(g, bindings);
            ++n2;
        }
    }

    @Override
    public IContextualModification execute(ReadGraph g, Object[] bindings) throws DatabaseException {
        int i = 0;
        while (i < this.rules.length) {
            IRule rule = this.rules[i];
            final IContextualModification modi = rule.execute(g, bindings);
            if (modi != null) {
                final int si = i + 1;
                if (si == this.rules.length) {
                    return modi;
                }
                return new ContextualModification(){

                    @Override
                    public void perform(WriteGraph g, Object[] bindings) throws DatabaseException {
                        modi.perform(g, bindings);
                        int j = si;
                        while (j < RuleConjunction.this.rules.length) {
                            RuleConjunction.this.rules[j].doExecute(g, bindings);
                            ++j;
                        }
                    }
                };
            }
            ++i;
        }
        return null;
    }
}

